//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: CNJob --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNJob_h
#define __CNJob_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/SimTime.h>

extern CNClassDesc CN_JOB;	// Class CNJob description


/*
 * The class CNJob
 */

class CNJob : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNJob()
	:in(0),out(0),start(0),priority(0),length(0),orig_length(0) {}
    CNJob(CNParam *param)
	:in(0),out(0),start(0),priority(0),length(0),orig_length(0) {}
    CNJob(double len)
	:in(0),out(0),start(0),priority(0),length(len),orig_length(len) {}
    CNJob(int prio)
	:in(0),out(0),start(0),priority(prio),length(0),orig_length(0) {}
    CNJob(int prio, double len)
    	:in(0),out(0),start(0),priority(prio),length(len),orig_length(len) {}
    	 
  public:	/***** Public interface **************************************/
    CNSimTime in;            // job enters system
    CNSimTime out;           // job leaves system
    CNSimTime start;         // begin of serving
    
    int priority;            
    double length;           // length of job (time)
    double orig_length;      // original length (for interrupt strategies)
    

  private:	/***** Internal private members ******************************/


  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_JOB; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_JOB ? TRUE : CNObject::is_a(desc); }
        
    static CNJob *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNJob *)obj;
#   else
	return (CNJob *)( !obj || obj->is_a(CN_JOB)
	       ? obj : fatal_type(obj->class_desc(), CN_JOB) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNJob(param) : new CNJob; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNJob_h**/
