//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FormInt.h,v 0.27 1995/01/20 15:14:22 cncl-adm Exp cncl-adm $
 *
 * Class: CNFormInt --- Integers as CNStrings 
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFormInt_h
#define __CNFormInt_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/String.h>

extern CNClassDesc CN_FORMINT;	// Class CNFormInt description


/*
 * The class CNFormInt
 */

class CNFormInt : public CNString
{
  public:
    enum { right=1, left=2 }; 

  private:
    int val;
    char cfill;
    int form;
    int wide;
    
  private:

    void initialize( int a, int l, char fill, int f);

    /***** Constructors ******************************************************/
  public:
    CNFormInt()				// Default constructor
    { initialize(0, 1, ' ',  right); }
    CNFormInt(CNParam *param)		// CNParam constructor
    { initialize(0, 1, ' ',  right); }
    CNFormInt(int a, int w=1)
    { initialize(a, w, ' ',  right); }
    CNFormInt(int a, int w, char fill)
    { initialize(a, w, fill, right); }
    CNFormInt(int a, int w, char fill, int f) 
    { initialize(a, w, fill, f    ); }
    
    int get_value()      { return val;   }	// returns the value
    char get_fill()      { return cfill; }	// returns the fill char
    int get_format()     { return form;  }	// returns the format char
    int get_width()      { return wide;  }	// returns the width
    int value()          { return val;   }	// returns the value
    char fill()          { return cfill; }	// returns the fill char
    int format()         { return form;  }	// returns the format char
    int width()          { return wide;  }	// returns the width

    void set_value(int a);
    void set_fill(char f);
    void set_format(int f);
    void set_width(int w);
    void value(int a);
    void fill(char f);
    void format(int f);
    void width(int w);
    

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_FORMINT; };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_FORMINT ? TRUE : CNString::is_a(desc); };
        
    static CNFormInt *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFormInt *)obj;
#   else
	return (CNFormInt *)( !obj || obj->is_a(CN_FORMINT)
	       ? obj : fatal_type(obj->class_desc(), CN_FORMINT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFormInt(param) : new CNFormInt; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNFormInt_h**/
