#ifndef __SDLProcess_Main_h
#define __SDLProcess_Main_h

#include "SDLProcess_Game.h"
#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/QueueFIFO.h>
#include <CNCL/Int.h>
#include <CNCL/Double.h>
#include <CNCL/String.h>

#include "SDLProcess.h"

#include "SDLSystem_DemonGame_Signals.h"
#include "SDLSystem_DemonGame_Timers.h"
#include "SDLSystem_DemonGame_Channels.h"

extern CNClassDesc CN_SDLPROCESS_Main;

/*
 * The class SDLProcess_Main
 */

class SDLProcess_Main : public CNSDLProcess
{

 // Private members
private:

/*---- procedure declaration ----*/
virtual int process(int);


/*---- process state declaration ----*/
enum states
{
	INIT=0,
	Game_Off,
	Game_On
};

/*---- local variable declaration ----*/
	PId GameP;


/*--------- Constructors ---------*/
public:
SDLProcess_Main() {}
SDLProcess_Main(CNParam *param) {}

SDLProcess_Main(char*, CNSDLManager*, int);

/***** Member functions required by CNCL *********************************/
public:
virtual CNClassDesc class_desc() const
{
return CN_SDLPROCESS_Main;
};

virtual bool is_a(CNClassDesc desc) const
{
	return desc == CN_SDLPROCESS_Main ? TRUE : CNSDLProcess::is_a(desc);
};

static SDLProcess_Main *cast_from_object(CNObject *obj)
{
#ifdef NO_TYPE_CHECK
	return (SDLProcess_Main *)obj;
#else
	return (SDLProcess_Main *)( !obj || obj->is_a(CN_SDLPROCESS_Main)
		? obj : fatal_type(obj->class_desc(),CN_SDLPROCESS_Main) );
#endif
}

static CNObject *new_object(CNParam *param = NIL)
{ return param ? new SDLProcess_Main(param) : new SDLProcess_Main; }


virtual void print(ostream &strm = cout) const;
virtual void dump (ostream &strm= cout) const;
};

#endif /**SDLProcess_Main_h**/