#ifndef __SDLProcess_Game_h
#define __SDLProcess_Game_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/QueueFIFO.h>
#include <CNCL/Int.h>
#include <CNCL/Double.h>
#include <CNCL/String.h>

#include "SDLProcess.h"

#include "SDLSystem_DemonGame_Signals.h"
#include "SDLSystem_DemonGame_Timers.h"
#include "SDLSystem_DemonGame_Channels.h"

extern CNClassDesc CN_SDLPROCESS_Game;

/*
 * The class SDLProcess_Game
 */

class SDLProcess_Game : public CNSDLProcess
{

 // Private members
private:

/*---- procedure declaration ----*/
virtual int process(int);


/*---- process state declaration ----*/
enum states
{
	INIT=0,
	Losing,
	Winning
};

/*---- local variable declaration ----*/
	long Count;


/*--------- Constructors ---------*/
public:
SDLProcess_Game() {}
SDLProcess_Game(CNParam *param) {}

SDLProcess_Game(char*, CNSDLManager*, int);

/***** Member functions required by CNCL *********************************/
public:
virtual CNClassDesc class_desc() const
{
return CN_SDLPROCESS_Game;
};

virtual bool is_a(CNClassDesc desc) const
{
	return desc == CN_SDLPROCESS_Game ? TRUE : CNSDLProcess::is_a(desc);
};

static SDLProcess_Game *cast_from_object(CNObject *obj)
{
#ifdef NO_TYPE_CHECK
	return (SDLProcess_Game *)obj;
#else
	return (SDLProcess_Game *)( !obj || obj->is_a(CN_SDLPROCESS_Game)
		? obj : fatal_type(obj->class_desc(),CN_SDLPROCESS_Game) );
#endif
}

static CNObject *new_object(CNParam *param = NIL)
{ return param ? new SDLProcess_Game(param) : new SDLProcess_Game; }


virtual void print(ostream &strm = cout) const;
virtual void dump (ostream &strm= cout) const;
};

#endif /**SDLProcess_Game_h**/