------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                              G N A T . I O                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

package body Gnat.IO is

   ---------
   -- Get --
   ---------

   procedure Get (X : out Integer) is

      function Get_Int return Integer;
      pragma Import (C, Get_Int, "get_int");

   begin
      X := Get_Int;
   end Get;

   procedure Get (C : out Character) is

      function Get_Char return Character;
      pragma Import (C, Get_Char, "get_char");

   begin
      C := Get_Char;
   end Get;

   --------------
   -- Get_Line --
   --------------

   procedure Get_Line (Item : in out String; Last : out Natural) is
      I_Length : Integer := Item'Length;
      Nstore   : Integer := 0;
      C        : Character;

   begin
      loop
         Get (C);
         exit when Nstore = I_Length;

         if C = Ascii.LF then
            exit;
         end if;

         Item (Item'First + Nstore) := C;
         Nstore := Nstore + 1;
      end loop;

      Last := Item'First + Nstore - 1;
   end Get_Line;

   --------------
   -- New_Line --
   --------------

   procedure New_Line (Spacing : Positive := 1) is
   begin
      for J in 1 .. Spacing loop
         Put (Ascii.LF);
      end loop;
   end New_Line;

   ---------
   -- Put --
   ---------

   procedure Put (X : Integer) is

      procedure Put_Int (X : Integer);
      pragma Import (C, Put_Int, "put_int");

   begin
      Put_Int (X);
   end Put;

   procedure Put (C : Character) is

      procedure Put_Char (C : Character);
      pragma Import (C, Put_Char, "put_char");

   begin
      Put_Char (C);
   end Put;

   procedure Put (S : String) is
   begin
      for J in S'Range loop
         Put (S (J));
      end loop;
   end Put;

   --------------
   -- Put_Line --
   --------------

   procedure Put_Line (S : String) is
   begin
      Put (S);
      New_Line;
   end Put_Line;

end Gnat.IO;
