------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . C O M M A N D _ L I N E                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with System;
package body Ada.Command_Line is

   function Arg_Count return Natural;
   pragma Import (C, Arg_Count, "arg_count");

   procedure Fill_Arg (A : System.Address; Arg_Num : Integer);
   pragma Interface (C, Fill_Arg);

   function Len_Arg (Arg_Num : Integer) return Integer;
   pragma Interface (C, Len_Arg);

   --------------------
   -- Argument_Count --
   --------------------

   function Argument_Count return Natural is
   begin
      return Arg_Count - 1;
   end Argument_Count;

   --------------
   -- Argument --
   --------------

   function Argument (Number : in Positive) return String is
      Arg : aliased String (1 .. Len_Arg (Number));
   begin
      Fill_Arg (Arg'Address, Number);
      return Arg;
   end Argument;

   ------------------
   -- Command_Name --
   ------------------

   function Command_Name return String is
      Arg : aliased String (1 .. Len_Arg (0));
   begin
      Fill_Arg (Arg'Address, 0);
      return Arg;
   end Command_Name;

end Ada.Command_Line;
