-------------------------------------------------------------------------------
--                                                                           --
--               Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--                         Darren J Moffat                                   --
--                      moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: 
-- $RCSfile: svgalibgl.ads,v $
-- $Revision: 1.1 $
-- $Author: djm $
-- $Log: svgalibgl.ads,v $
-- Revision 1.1  1995/02/08  00:57:42  djm
-- entered into RCS
--

with Interfaces.C;

package SVGALibGL is

   ----------------------------------------------------------------------
   -- Graphics Contexts
   ----------------------------------------------------------------------

   type Mode_Type is (Virtual, Paged, Linear, ModeX, Planar16);
   for Mode_Type use (Virutal => 0x0, Paged => 0x1, Linear => 0x2,
		      ModeX => 0x3, Planar16 => 0x4);

   type Mode_Flag is (Page_Flipping_Capable,
		      Tripple_Buffering_Capable,
		      Page_Flipping_Enabled,
		      Tripple_Buffering_Enabled,
		      Flip_Page_Bank_Aligned,
		      BPP32_Shift8);
   for Mode_Flag use (Page_Flipping_Capable => 0x01,
		      Tripple_Buffering_Capable => 0x02,
		      Page_Flipping_Enabled => 0x04,
		      Tripple_Buffering_Enabled => 0x08,
		      Flip_Page_Bank_Aligned => 0x10,
		      BPP32_Shift8 => 0x20);

   type Frame_Buffer_Functions is record
	int (*driver_setpixel_func)(int, int, int);
	int (*driver_getpixel_func)(int, int);
	int (*driver_hline_func)(int, int, int, int);
	int (*driver_fillbox_func)(int, int, int, int, int);
	int (*driver_putbox_func)(int, int, int, int, void *, int);
	int (*driver_getbox_func)(int, int, int, int, void *, int);
	int (*driver_putboxmask_func)(int, int, int, int, void *);
	int (*driver_putboxpart_func)(int, int, int, int, int, int, void *,
		int, int);
	int (*driver_getboxpart_func)(int, int, int, int, int, int, void *,
		int, int);
	int (*driver_copybox_func)(int, int, int, int, int, int);
   end record;


   type Graphics_Context is record
      	Mode : Mode_Type;  -- virtual, paged, linear, mode X or planar16
	Flags: Mode_Flag;  
	Dummy : Natural;
	Flip_Page : Boolean;
	Width : Dimmension;	   -- width in pixels
	Height: Dimmension;        -- height in pixels
	Bytes_Per_Pixel : Integer; -- bytes per pixel (1, 2, 3, or 4)
	Colours : Integer;	   -- number of colors
	Bitsperpixel : Integer;    -- bits per pixel (8, 15, 16 or 24)
	Byte_Width : Integer;	   -- length of a scanline in bytes
	Frame_Buffer : ???;	   -- address of framebuffer
	Clip : Boolean;	           -- clipping enabled?
	ClipTL : Point;            -- top-left coordinate of clip window
	ClipBR : Point;            -- bottom-right coordinate of clip window
	FF : Frame_Buffer_Functions;
   end record;

end SVGALibGL;
