-------------------------------------------------------------------------------
--                                                                           --
--		 Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--			   Darren J Moffat                                   --
--			moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: 
-- $RCSfile: svgalib.adb,v $
-- $Revision: 1.2 $
-- $Author: djm $
-- $Log: svgalib.adb,v $
-- Revision 1.2  1995/03/01  20:06:56  djm
-- Changed from using constant Integer to and enumeration,
-- for the VgaMode type.
--
-- Revision 1.1  1995/02/08  00:57:10  djm
-- entered into RCS
--


with Interfaces.C;

package body SVGALib is


   procedure Set_Mode (Mode : VgaMode := G320x200x16) is
      function C_Set_Mode (Mode : VgaMode) return Boolean;
      pragma Import (C, C_Set_Mode, "vga_setmode");
   begin
	if C_Set_Mode (Mode) then
	   raise Invalid_Vga_Mode;
	end if;
   end;

   procedure Set_Palette (Palette : in Natural; Colour : in RGBColour) is
      procedure C_Set_Palette (Palette, Red, Green, Blue : in Integer);
      pragma Import (C, C_Set_Palette, "vga_setpalette");
   begin
      C_Set_Palette (Palette, Colour.Red, Colour.Green, Colour.Blue);
   end Set_Palette;

    
   procedure Get_Palette (Palette : in Natural; Colour : out RGBColour) is
      procedure C_Get_Palette (Palette : in Integer;
			       Red, Green, Blue : out Integer);
      pragma Import (C, C_Get_Palette, "vga_getpalette");
   begin
      C_get_Palette (Palette, Colour.Red, Colour.Green, Colour.Blue);
   end Get_Palette;


   procedure Draw_Pixel (P : Point) is
      procedure C_Draw_Pixel (X,Y : Integer);
      pragma Import (C, C_Draw_Pixel, "vga_drawpixel");
   begin
      C_Draw_Pixel (P.X, P.Y);
   end Draw_Pixel;


   procedure Draw_Line (T,B : in Point) is
      procedure C_Draw_Line (X1,Y1,X2,Y2 : in Integer);
      pragma Import (C, C_Draw_Line, "vga_drawline");
   begin
      C_Draw_Line (T.X, T.Y, B.X, B.Y);
   end Draw_Line;


end SVGALib;
