static char rcsid[] = "$Id: signals.c,v 1.2 1992/01/17 23:02:16 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/* signals.c
 *
 *   Signal handling for mxgdb and gdb.
 *
 *   kill_hanlder():	For SIGQUIT, SIGILL, SIGBUS, SIGTERM, SIGKILL
 *			print error message and exit with signal status
 *                      (static).
 *   quit_handler():	SIGCHLD, wait for gdb to die and exit gracefully
 *                      (static).
 *   stop_handler():	SIGTSTP, stop gdb process, then stop own process
 *                      (static).
 *   cont_handler():	SIGCONT, continue gdb process (static).
 *   trap_signals():	Install signal handlers.
 */

#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include "global.h"

/*  Kill the gdb child process and then exits. */
static void kill_handler(sig, code, scp, addr)
    int sig, code;
    struct sigcontext *scp;
    char *addr;
{
    if (FalseSignal) {
	FalseSignal = FALSE;
	return;
    }
    if(xttypid > 0)
      kill(xttypid, SIGKILL);
    if(gdbpid > 0)
      kill(gdbpid, SIGKILL);
    
    switch (sig) {
    case SIGQUIT : fprintf(stderr, "Quit\n"); break;
    case SIGILL  : fprintf(stderr, "Illegal instruction\n"); break;
    case SIGBUS  : fprintf(stderr, "Bus error\n"); break;
    case SIGSEGV : fprintf(stderr, "Segmentation violation\n"); break;
    case SIGTERM : fprintf(stderr, "Soft kill\n"); break;
    case SIGKILL : fprintf(stderr, "Killed\n"); break;
    }
    exit(sig);
}


static void quit_handler()
{

  int status;
  int pid;
  char command[LINESIZ];

    /*  wait for the child to report its status; if the child has died, 
     *  exit gracefully for gdbpid, reset tty for xttypid.
     */

  pid = wait(&status);

  if ((pid == gdbpid) && (WIFEXITED(status) || WIFSIGNALED(status)) && 
      !WIFSTOPPED(status)) 
    {
      if(xttypid > 0)
	kill(xttypid, SIGKILL);
      exit(1);
    }

  if((pid == xttypid) && (WIFEXITED(status) || WIFSIGNALED(status)) && 
      !WIFSTOPPED(status)) 
    {
      xttyname = NULL;
      sprintf(command, "tty %s\n", gdbtty);
      send_command(command);
      AppendDialogText(command);
    }
}

/*
 *  Trap signals to mxgdb so that the child process can be handled properly.
 */
void trap_signals()
{
    sigset(SIGQUIT, kill_handler);
    sigset(SIGILL,  kill_handler);
    sigset(SIGBUS,  kill_handler);
    sigset(SIGSEGV, kill_handler);
    sigset(SIGTERM, kill_handler);
    sigset(SIGKILL, kill_handler);
    sigset(SIGCHLD, quit_handler);	/* child status has changed */
}
