// $Id: cxxtest.C,v 1.5 1995/05/10 08:34:41 zeller Exp $ 
// Test program

// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Dorothea Luetkehaus (luetke@ips.cs.tu-bs.de).
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, write to the Free Software Foundation, Inc.,
// 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// DDD is the GDB-based data display debugger.
// Contact ddd@ips.cs.tu-bs.de for details.

//--------------------------------------------------------------------------
// This program defines some data structures and values that may be
// examined using DDD.
//--------------------------------------------------------------------------

char cxxtest_rcsid[] =
    "$Id: cxxtest.C,v 1.5 1995/05/10 08:34:41 zeller Exp $";

#include <iostream.h>

enum DayOfWeek {Sun, Mon, Tue, Wed, Thu, Fri, Sat};

//--------------------------------------------------------------------------
class Date {
    DayOfWeek day_of_week;
    int day;
    int month;
    int year;
public:
    Date ()
	: day_of_week(Thu), day(1), month(1), year(1970)
    {}
    Date (DayOfWeek w, int d, int m, int y)
	: day_of_week(w), day(d), month(m), year(y)
    {}
    virtual ~Date ()
    {}
    void set (DayOfWeek w, int d, int m, int y)
    {
	day_of_week = w;
	day         = d;
	month       = m;
	year        = y;
    }

    virtual void print() {}
};

//--------------------------------------------------------------------------
class Holiday : public Date {
    const char *name;

public:
    Holiday (DayOfWeek w, int d, int m, int y, const char *n) :
	Date (w, d, m, y), name(n)
    {}
    virtual ~Holiday ()
    {}

    virtual void print() {}
};
//--------------------------------------------------------------------------
class Tree {
    int   value;
    const char *name;
public:
    Date date;
    Tree* left;
    Tree* right;

    Tree (int v, char* n):
	value(v), name(n), left(0), right(0)
    {}
    ~Tree () 
    {
	if (left)
	    delete left;
	if (right)
	    delete right;
    }
};
//--------------------------------------------------------------------------
void tree_test ()
{
    Tree* tree = 0;
    tree =              new Tree (7, "Ada");      // Byron Lovelace
    tree->left =        new Tree (1, "Grace");    // Murray Hopper
    tree->left->left =  new Tree (5, "Judy");     // Clapp
    tree->left->right = new Tree (6, "Kathleen"); // McNulty
    tree->right =       new Tree (9, "Mildred");  // Koss

    tree->date.set(Tue, 29, 11, 1994);
    tree->date.set(Wed, 30, 11, 1994);

    delete tree;
}    
//--------------------------------------------------------------------------
void reference_test (Date& date, Date*& date_ptr)
{
    date = *date_ptr;
    delete date_ptr;
    date_ptr = 0;
}

//--------------------------------------------------------------------------
void array_test ()
{
    DayOfWeek days_of_week[7] = {Sun, Mon, Tue, Wed, Thu, Fri, Sat};

    char* twodim [2][3] = {{ "Pioneering", "women", "in"},
			   { "computer", "science", "!"}};

    Date* date_ptrs[4];
    date_ptrs[0] = new Date (Thu, 1, 9, 1994);
    date_ptrs[1] = new Date (Tue, 10, 5, 1994);
    date_ptrs[2] = new Date (Fri, 15, 7, 1994);
    date_ptrs[3] = new Date (Sat, 24, 12, 1994);

    Date dates[4];
    for (int i = 0; i < 4; i++)
	reference_test(dates[i], date_ptrs[i]);
}
//--------------------------------------------------------------------------
struct Guni {
    int ii;
    union {
	int j;
	char c;
    };
};
void type_test ()
{
    Holiday new_years_eve (Sat, 31, 12, 1994, 
			   "May all acquaintance be forgot");

    Date* date = new Date(Sat, 24, 12, 1994);
    void* voidptr = date;

    struct Uni {
	int ii;
	union {
	    int j;
	    char c;
	}u;
    } uni;
    Guni guni; 
    uni.ii  = 7;
    uni.u.j = 9;
    guni.j  = 8;

    float f        = 0.0;
    double d       = 0.0;
    signed char sc = 'a';
}
//--------------------------------------------------------------------------
void cin_cout_test ()
{
    // Simple I/O
    char name[1024];
    cout << "What's your name? ";
    cin >> name;
    cout << "Hello, " << name << "!\n";
}
//--------------------------------------------------------------------------
int main (int argc, char* argv[])
{
    int i = 42;
    tree_test();
    i++;
    array_test();
    i++;
    type_test();
    --i;
    cin_cout_test();
    return 0;
}
