/* bdm-util.h - define info for access to S-Record files */

#include	"sizedefs.h"

/* first define a structure for easy access to S-record info */

#define	SREC_MAXCOUNT		64

typedef struct {
	int rectype;
	int reclen;
	LONG address;
	char bytes [SREC_MAXCOUNT];
} srecord;

/* some global data */

/* PrintEachRecord points to a string to be printed
 * for each S-record successfully downloaded
 */

extern char *PrintEachRecord;

/* ExecuteAddress contains address from S9 record
 * starting execution address
 */

extern LONG ExecuteAddress;

/* function calls in bdm-util.c */

int do_srec (srecord *, FILE *);
void put_srec (srecord *, LONG);
int do_load (LONG load_offset, char *infilename);

/* return values from do_srec () */

#define SREC_EOF        1       /* end of file before S9 record */
#define SREC_S9         2       /* S9 record reached */
#define SREC_CHECKSUM   3       /* checksum error in record */
#define SREC_FORMAT     4       /* S-record format error */

/* end */
