#ifndef _ERROR_HANDLER_H_
#define _ERROR_HANDLER_H_
/*
 *	Declarations for functions and macros to handle errors.
 */


extern void	handleError(int, int, char*);

/*
 *	This macro processes the error and retries the operation
 */
#define HANDLE_ERROR_ABORTED(_code, _retryLocation)				\
	if ((_code) == esmTRANSABORTED) {							\
		handleError((_code), __LINE__, __FILE__);		\
		goto _retryLocation;									\
	} else {													\
		handleError((_code), __LINE__, __FILE__);									\
	}

/*
 *	This macro just handles the error
 */
#define HANDLE_ERROR(_code)				\
	handleError((_code), __LINE__, __FILE__);					\

#endif /* _ERROR_HANDLER_H_ */
