/*
 * $RCSfile: var.c,v $
 * $Revision: 1.1 $
 * $Date: 1993/02/15 17:33:37 $
 */
#include "et.h"
#include "etError.h"
#include "func.h"

VarType		*firstVarPtr = NULL;
VarType		*lastVarPtr = NULL;
VarType		*currentVar = NULL;

/********************************************************************
 *
 *      createVar
 *
 *******************************************************************/
VarType     *
createVar(char *name)
{
    VarType     *p;

    if (!(p = (VarType *)malloc(sizeof(VarType)))) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, MALLOC_ERR);
    }

    strcpy(p->name, name);
    p->nextVar = NULL;
	if(firstVarPtr == NULL)
		firstVarPtr = lastVarPtr = p;
	else {
		lastVarPtr->nextVar = p;
		lastVarPtr = p;
	}
	return p;
}


/********************************************************************
 *
 * 	existVar	
 *	    returns TRUE if a variable with a particular name
 *	    already exists, else returns FALSE.
 *
 *******************************************************************/
BOOL existVar( char *variable, VarType **returnPtr)
{
	VarType *p;
    p = firstVarPtr;

    while(p) {
		/* 
		 *  if a variable with the same name already exists
		 */
		if (!strcmp(p->name, variable)) {
			*returnPtr = p;
			return TRUE;
		}

		p = (VarType *)(p->nextVar);
    }
	*returnPtr = NULL ;
    return FALSE;
}


/********************************************************************
 *
 * 	getString
 *	    returns TRUE if the variable sought has been found,
 *		and the string is copied into varValue	
 *	    else return FALSE, and if printErrorMesg (passed in)
 *	    is set, an error message will be printed.
 *
 *******************************************************************/
BOOL getString( 
		char	*varName,
		char 	*varValue,
		BOOL	printErrorMesg
)
{
    VarType	*returnPtr;

	if (!existVar(varName, &returnPtr)) {
		if (printErrorMesg) {
			INFO
				"%s:", varName
			ENDINFO
			HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, NOSUCHVARIABLE);
		}
		return FALSE;	
	}

    strcpy(varValue, returnPtr->itstring);
    return TRUE;
}




/********************************************************************
 *
 *  	listVar	
 *	    prints out all the variables that have been declared.
 *
 *******************************************************************/
void listVar()
{
	VarType *p;

    for(p = firstVarPtr;p!=NULL; p = p->nextVar) {
		printf("\t%s\t%s\n", p->name, p->itstring);
    }
}

void freeVar()
{
    VarType     *p;

    while(p = firstVarPtr) {
		firstVarPtr = p->nextVar;
		free(p);
    }
	firstVarPtr = NULL;
	lastVarPtr = NULL;
}

void setVar(char	*vname, char *value)
{
    VarType     *itsPtr;

	if (!existVar(vname, &itsPtr)) {
		itsPtr = createVar(vname);
	}

    /*
     *    copy all non-blank, non-tab characters of the variable
     *    r-value from inputLine to itstring before the newline.
     */
	
	if(strlen(value) > STRINGSIZE) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, STRING_TOOLONG);
		INFO
			"variable %s not set\n", vname
		ENDINFO
	} else {
		strcpy(itsPtr->itstring, value);
	}
}

/********************************************************************
 *
 *	replaceDollars	     	
 *	    returns FALSE if the inputLine contains an undeclared
 *	    variable; else it returns TRUE, and it repetitively
 *	    replaces variables with their values until inputLine
 *	    contains no more '$'s.   
 *
 *******************************************************************/

BOOL replaceDollars(char *inputLine)
{
    char buffer[INPUTSIZE + 1];		
    char varName[VARIABLESIZE];
	int	 n;
	BOOL dollarfound = FALSE;
	char *i, *b,  *d;
		/* i is for input, b is for buffer (output), d is for destination */

#define isnull(c) ((c) == '\0')

	for (n = 0, i = inputLine, b = buffer; n < INPUTSIZE; n++) {

		/* get next interesting character */
		while( isspace(*i) ) i++;

		/* done? */
		if(isnull(*i)) break;

		/* dollar sign? */
		if( *i == '$' ) {
			/* put the variable name aside so we can make the substitution */
			i++; /* skip the dollar */
			dollarfound = TRUE;
			d = varName;
		} else {
			/* just keep copying from input to buffer */
			dollarfound = FALSE;
			d = b;
		}

		/* copy the word to buffer or to variable name */
		while ( (!isspace(*i)) && (!isnull(*i)) ) {
			*d++ = *i++;
		}

		if(dollarfound) {
			/* end the string variable name */
			*d = '\0';  /* don't increment it */

			if (getString(varName, b, TRUE)) {
				/* getString put the value into its 3rd argument */
				b += strlen(b);
			} else 
				return FALSE;
		} else {
			b = d;
		}

		/* put a space into the output */
		*b++ = ' ';
	}
	*b = '\0';
	strcpy(inputLine, buffer);
	return TRUE;
}
