/*
 * $RCSfile: scan.c,v $
 * $Revision: 1.11 $
 * $Date: 1993/04/29 16:33:20 $
 */
#include "et.h"
#include "etError.h"
#include "func.h"
#define __SCAN_C__
#include "command_funcs.h"
#include "trie.h"

char			*Whitespace = "\t "; /* tab and blank */
char			InputLine[INPUTSIZE];
char			InputLineSave[INPUTSIZE]; /* saved from the ravages of strtok(), so it's
											* available for SYNTAXERROR to print. */
int				InputLineNumber=0;
static 	TRIE 	WordTrie;
static 	WORDLIST Words;
static  int	 	*cmd2indices;
static FILE 	*scriptPtr = NULL;	
static int		restartPos = 0;
BOOL			fileOp=FALSE;
static int		restartLineNumber = 0;	/* where go if we back up to restart a tx */


static struct table {
	char *word;
	int	 (*command)(ELIPSES);
	int	 cmd;
	char *help;
} Table[] = {
	{"addvolume", addvol_command, WORD_ADD,
		"addvolume {option name} {format info} [serverlist] "
	},
	{"rmvolume", rmvol_command, WORD_ADD,
		"rmvolume volid [serverlist]"
	},
	{"clientoption", clientoption_command, WORD_CLIENTOPTION,
		"clientoption {option name} {option value} "
	},
	{"configfile", configfile_command, WORD_CONFIGFILE, 
		"configfile {filename} [{programname}](default=this)"
	},
	{"session", session_command, WORD_SESSION,
		"session [-f|-F {fileRootEntry}] [-v {volid}] [-b {#bufGroupPages}] [-r]"
	},
	{"commit", commit_command, WORD_COMMIT, "commit" },
	{"create", create_command, WORD_CREATE, 
		"create {#bytes} [{howMany}](default=1)" },
	{"append", append_command, WORD_APPEND,
		"append {obj#} {#bytes} [{howMany}](default=1)" },
	{"connect", connect_command, WORD_CONNECT, "connect {#attempts}" },
	{"checkpoint", intarg_command, WORD_CHECKPOINT, "checkpoint {#times}" },
	{"destroy", destroy_command, WORD_DESTROY, 
		"destroy {obj#} [{howMany}](default=1)" },
	{"delete", delete_command, WORD_DELETE,
		"delete {obj#} {location} {#bytes} [{howMany}](default=1)" },
	{"echo", echo_command, WORD_ECHO, 
		"echo [stdout | stderr | {filename}](default=stdout)" 
	},
	{"exit", exit_command, WORD_EXIT, "exit" },
	{"quit", exit_command, WORD_EXIT, "quit" },
	{"stdout", no_command, WORD_STDOUT, "" },
	{"stderr", no_command, WORD_STDERR, "" },
	{"flush", flush_command, WORD_FLUSH, "flush" },
	{"frequency", intarg_command, WORD_FREQUENCY, "frequency {#records}" },
	{"help", help_command, WORD_HELP, "help [{command}]" },
	{"objectsizelimit", no_command, WORD_OBJSIZELIMIT, 
	"objects will not be made larger than this" },
	{"insert", insert_command, WORD_INSERT,
		"insert {obj#} {location} {#bytes} [{howMany}](default=1)" },
	{"list", list_command, WORD_LIST, "list" },
	{"loglevel", no_command, WORD_LOGLEVEL, "log level for files" },
	{"noecho", noecho_command, WORD_NOECHO, "noecho" },
	{"none", no_command, WORD_NADA, "nada, rien, nothing, none" },
	{"print", print_command, WORD_PRINT, "print ca | ua | volid | transaction " },
	{"random", random_command, WORD_RANDOM,
	"random [{#operations}] [{startobj#} [{endobj#}](default=startobj#) ](default=all)"
	},
	{"volid", no_command, WORD_VOLID,  "volume id for object creation" },
	{"transaction", no_command, WORD_TRANSACTION, 
		"volumes/servers used by this transaction -or- transaction status" },
	{"used", no_command, WORD_USED, "volumes/servers used since init" },
	{"all", no_command, WORD_ALL, "all volumes/servers" },
	{"space", no_command, WORD_SPACE, "log only space allocation/deallocation" },
	{"randop", no_command, WORD_RANDOP, 
		"tells what operations will be used in the next \"random\" command" },
	{"read", read_command, WORD_READ, "read objNum [{howMany}](default=1)" },
	{"scan", scan_command, WORD_SCAN, "scan" },
	{"seed", no_command, WORD_SEED, "seed for random operations" },
	{"set", set_command, WORD_SET,
	"set {variable name} {string}\nset randop {random-op}*\nset echo stdout|stdin|{filename}\nset volid cycle|random|{volid}\nset seed {number}\n"
	},
	{"reset ", reset_command, WORD_RESET, "reset [serverstats command | rusage command]" },
	{"serverstats", serverstats_command, WORD_SERVER, "serverstats [serverlist]" },
	{"serverlist", no_command, WORD_NONE, "[all | transaction | used | <[o{obj#} | v{volid}]*> ] (default=all)" },
	{"sleep", intarg_command, WORD_SLEEP, "sleep {#seconds}" },
	{"sync", sync_command, WORD_SYNC, "sync -- syncs current tx to disk" },
	{"validate", validate_command, WORD_VALIDATE,
		"validate ua|ca [ {obj#} [{howMany}](default=1) ](default=all)",
	},
	{"ua", no_command, WORD_UA, "uncommitted objects" },
	{"ca", no_command, WORD_CA, "committed objects" },
	{"version", version_command, WORD_VERSION, "version objNum" },
	{"write", write_command, WORD_WRITE,
		"write objNum location numOfBytes [{howMany}](default=1)"
	},
	{"prepare", prepare_command, WORD_PREPARE, "prepare" },
	{"enter2PC", enter2PC_command, WORD_ENTER, 
		"enter2PC [{logfilename}](default=\"et.log\")" },
	{"recover2PC", recover2PC_command, WORD_RECOVER, 
		"recover2PC [{logfilename}](default=\"et.log\") [commit | abort]" },
	{"continue2PC", continue2PC_command, WORD_CONTINUE, 
		"continue2PC [TRUE|FALSE](default= willing-to-block is TRUE)" },
	{"servervar", servervar_command, WORD_SERVERVAR, 
		"servervar variable value [abort serverlist  ]"},
	{"crashserver", crashserver_command, WORD_CRASH, 
		"crashserver [serverlist]"},
	{"abort", abort_command, WORD_ABORT, "abort" },
	{ 0, 0, WORD_NONE, "# comment"},
	{ 0, 0, WORD_NONE, "-- Allowable random operations --" },
	{ 0, 0, WORD_NONE, "create, destroy, delete, insert, append, write, version, sleep"},
	{ 0, 0, WORD_NONE, 0}
};

void
getnewline()
{
	for(;;) {
		InputLineNumber++; 
		if (gets(InputLine) == NULL) {
			HANDLE_ERROR(CAUSE_USER, TREAT_FATAL, ENDOFFILE);
		}; 
		strcpy(InputLineSave, InputLine);
		echo(InputLineNumber, InputLine);
		if(InputLine[0] != '\0')
			break;
	}
}

void
init_scan()
{
	/* count the commands and make a separate wordlist for them */
	struct table *t;
	register int i;

	for(i=0, t = Table; t->command != 0; t++, i++);

	Words = (WORDLIST) calloc(i+1, sizeof(char *));
	cmd2indices = (int *) calloc(MAX_WORD+1, sizeof(int));

	for(i=0, t = Table; t->command != 0; t++, i++) {
		Words[i] = t->word;
		if(t->cmd != WORD_NONE) {
			cmd2indices[t->cmd - MIN_WORD] = i;
		}
	}
	Words[i] = 0;  /* mark the end of the list */
	WordTrie = trie_make(Words);

}

int
word2cmd( char *word ) 
{
	int i;

	i = trie_search(WordTrie, word, (FILE *)stdout, FALSE);
	if(i == NOMATCH)
		return WORD_NONE;
	return Table[i].cmd;
}

int
word2index( char *word ) 
{
	return trie_search(WordTrie, word, (FILE *)stdout, FALSE);
}

int
getnum(char *arg, int *num)
{
	errno = 0;

	if (arg) {
		*num = (int) atoi(arg);
	} else {
		errno = ERANGE;
	}
	if(errno == ERANGE) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
		return esmFAILURE;
	}
	return esmNOERROR;
}
int
cmd2index(int cmd)
{
	int i = cmd - MIN_WORD;

	if(i >= 0) {
		return cmd2indices[i];
	} else {
		return cmd;
	}
}

char * 
cmd2word(int cmd)
{
	int i = cmd - MIN_WORD;

	if(i >= 0) {
		i = cmd2indices[i];
	} else {
		i = cmd;
	}
	return Table[i].word;
}

void
restart_starts_here()
{
	if (fileOp) {
		restartPos = (int) ftell(stdin);
		restartLineNumber = InputLineNumber;
	}
}

void
restart()
{
	if (fseek(stdin, restartPos, 0) != 0) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, SCRIPT_FILE);
	}
	InputLineNumber = restartLineNumber;
}
void
close_script()
{
    if (fileOp)
	    fclose(scriptPtr);
}

void
open_script(char *path)
{
	fileOp = TRUE;

	if ((scriptPtr = fopen(path, "r")) == NULL) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, SCRIPT_FILE);
	}

	if (fseek(scriptPtr, 0, 0) != 0) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, SCRIPT_FILE);
	}
   
	dup2((int)scriptPtr, 0);
}

void 
checkStatus(BOOL seekToNextTx)
{
    BOOL  seekBack;
    
    if (interactive) /* input from a keyboard */ {
		(void) abort_tx(TRUE);
		seekBack = FALSE; /* cannot go back */
		seekToNextTx = FALSE; /* cannot go forward either */
    } else if (fileOp)  /* input is from a file */ {
		seekBack = abort_tx(TRUE);   
	}	else	/* from a pipe */ {
		(void) abort_tx(TRUE);
		seekBack = FALSE; /* cannot go back in a pipe */
	}
	/*  We'd like to seek backwards and re-run this tx
	 *  in the "normal" case, but if we're artificially
	 *  aborting (testing with SM_FakeFailure), we'll 
	 *  loop forever doing this, so we'd better prevent that...
	 */
	if(FakingFailure) {
		seekBack = FALSE;
	}


	if(seekBack) {
		restart();
	} else if (seekToNextTx) {
		/* we aborted  */
		/* we read until we see an abort or commit. */
		get_command(GET_COMMAND_ENDTX, FALSE);
	} /* else keep reading from here: we'll get esmNOACTIVETRANS errors */

} /* checkStatus */

void
ignore_restofline()
{
	char *del = "\0127";
	char *rest;

	if(rest = strtok(NULL,del)) {
		INFO
			"ignoring \"%s\"\n", rest
		ENDINFO
	}
}

/*
 * grot: get_command gets a command, possibly skipping 
 * certain types, subject to the first argument, "which", 
 * which tells what command(s) we are looking for.
 * get_command() leaves a ptr to the command's table entry
 * in last_command.  Do_command() uses it.
 */
static struct table *last_command;

int
get_command(int which, BOOL prompt)
{
	int	 index, result;
	char *command;

	last_command = NULL;
	for(;;) {
		if(prompt)
			PROMPT;

		GETNEWLINE; /* also echoes */

		if(InputLine[0] == '#') 
			continue;

		if (!replaceDollars(InputLine)) 
			return NOMATCH;

		command = first_commandarg(Whitespace);

		if(command==NULL) {
			return NOMATCH;
		}
		if(command[0] == '#') 
			continue;

		/*
		* calls to strtok(NULL, command-dependent delimiters) yields the rest
		* and these are done in the individual command-specific routines
		*/

		index = trie_search(WordTrie, command, (FILE *)stdout, TRUE);

		if( index == NOMATCH ) {
			HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, NOSUCHCOMMAND);
			continue;
		}
		last_command = &Table[index];

		if (Table[index].cmd != WORD_NONE)  {
			result = Table[index].cmd;
		} else result = index;

		if( which == GET_COMMAND_ANY ) {
			return result;
		}
		if( which == GET_COMMAND_SESSION ) {
			switch(result) {
			case WORD_HELP:
			case WORD_RECOVER:
			case WORD_SET:
			case WORD_ECHO:
			case WORD_NOECHO:
			case WORD_LIST:
			case WORD_PRINT:
			case WORD_EXIT:
			case WORD_CLIENTOPTION:
			case WORD_ADD:
			case WORD_RM:
			case WORD_CONFIGFILE:
				(void) do_command(result);
				continue;

			case WORD_SESSION:
				return result;

			default:
				INFO 
				"Illegal command at line %d.  Allowed commands:\n" , InputLineNumber
				ENDINFO
				INFO 
				"help, exit, recover2PC, session, set, clientoption, configfile, echo, noecho, list, print, addvolume, rmvolume.\n"
				ENDINFO
				if(interactive) {
					continue; /* keep looking */
				} else {
					/* not interactive - stop */
					HANDLE_ERROR(CAUSE_USER, TREAT_FATAL, NOSUCHCOMMAND);
				}
			}
		} /* looking for session */
		if( which == GET_COMMAND_ENDTX ) {
			switch(result) {
			case WORD_ABORT:
			case WORD_COMMIT:
				return result;
			case WORD_EXIT:
				(void) do_command(result);
				/* won't return to here */
				return result;

			default:
				if(interactive) {
					/* shouldn't call this if interactive */
					HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, esmINTERNAL);
				}
				continue; /* keep looking */
			}
		}
	}
}

int
do_command(int index)
{
	int e;

	clear_connect_error();
	if(last_command == NULL) {
		return WORD_NONE; /* ignore - was a syntax error */
	}
	if( last_command->cmd == WORD_NONE) {
		if(last_command != &Table[index]) {
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, esmINTERNAL);
		}
	} else {
		if(last_command->cmd != index) {
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, esmINTERNAL);
		}
	}
	e = (*(last_command->command))(index);
	return e;
}
int
help_command(ELIPSES)
{
	char *arg = next_commandarg(Whitespace);
	register int i;

	if(arg) {
		i = word2index(arg);
		if(i == NOMATCH) {
			HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
			INFO
				"Syntax of help command:  help  [{command}]\n"
			ENDINFO
			return esmFAILURE;
		}

		INFO
			"%s\n", Table[i].help
		ENDINFO
		return esmNOERROR;
	}
	for(i=0; Table[i].help != 0; i++) {
		if(Table[i].command != no_command) {
			INFO
				"%s\n", Table[i].help
			ENDINFO
		}
	}
	return esmNOERROR;
}

char *
next_word (char *str, char *delimiters)
{
	char *c;

	c =  strtok(str, delimiters);
	DEBUGINFO
		"next_word returns %s\n",c
	ENDINFO

	return c;

}

char *
first_commandarg( char *delimiters ) 
{
	return next_word(InputLine, delimiters);
}
char *
next_commandarg( char *delimiters ) 
{
	return next_word(NULL, delimiters);
}
