/*
 * $RCSfile: random.c,v $
 * $Revision: 1.3 $
 * $Date: 1993/02/15 17:34:14 $
 */
#include "et.h"
#include "etError.h"
#include "func.h"
#include "command_funcs.h"

static int randops[100];
static int nrandops = 0;

int
set_randop( char *str )
{
	char *arg = next_word(str, Whitespace);
	int	cmd;

	if(!arg) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
		return esmFAILURE;
	}
	for(nrandops=0; arg != NULL; nrandops++) {
		switch(cmd = word2cmd(arg)) {
		case WORD_CREATE:
		case WORD_DESTROY:
		case WORD_DELETE:
		case WORD_INSERT:
		case WORD_APPEND:
		case WORD_WRITE:
		case WORD_VERSION:
		case WORD_SLEEP:
			randops[nrandops] = cmd;
			INFO
				"adding command %s to random set\n", cmd2word(cmd)
			ENDINFO
			break;
		default:
			HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
			ignore_restofline();
			return esmFAILURE;
		}
		arg = next_word(0, Whitespace);
	}
	return esmNOERROR;
}
void
print_randop()
{
	register int i;

	if(nrandops == 0) {
		INFO
			"randop is not set."
		ENDINFO
		return;
	}
	INFO
		"randop is: "  
	ENDINFO
	for(i=0; i< nrandops; i++) {
		INFO
		 " %s",cmd2word(randops[i])
		ENDINFO
	}
	INFO
		"\n"  
	ENDINFO
}

static int
set_sleepLimit()
{
	int     sleepLimit;
    char	sleepStr1[10];
    char	sleepStr2[10];

	/*
	 *	get sleepLimit (if set) from variable "sleep",
	 *  convert it from char to int; else use the default
	 *  value. 
	 */
	if (!getString( "sleep", sleepStr1, FALSE))
		sleepLimit = SLEEPDEFAULT;
	else {
		strcpy(sleepStr2, sleepStr1);
		sleepLimit = atoi(sleepStr2);
	}
	return sleepLimit;
}

static int
random_operation(int count, int startObj, int endObj )
{
	BOOL	all = ((startObj == 0)&&(endObj == objUACount));
												/* objUACount may change */
	int 	sleepLimit = set_sleepLimit();
	int		cmd, nbytes, location, howMany, objnum;
	ObjInfo	*objinfo;
	int 	currentObjSize = 0;

	if(nrandops < 1) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, RAND_NOT_SET);
		return esmFAILURE;
	} 

	for(; count>0; count--) {
		/* create input line */

		cmd = randops[(int)random() % nrandops];

		switch(cmd) {
		case WORD_CRASH:
			/* no input */
			InputLine[0] = '\0';
			sprintf(InputLine, "randomcrash");
			break;
		case WORD_SLEEP:
			/* input line is a # seconds */
			if(sleepLimit > 0)
				sprintf(InputLine, "randomsleep %d", ((int)random() % sleepLimit));
			else {
				sprintf(InputLine, "randomsleep 0");
			}
			break;
		default:
			/* we will pretend that we need : obj#, location, #bytes, #objs */
			if(all) {
				objnum = 0;
				/* howMany = objUACount; */
			} else {
				objnum = startObj; 
				/* howMany = endObj - startObj + 1; */
			}
			/* if(howMany == 0) */ howMany = 1;
			objinfo = &UA[objnum];
			currentObjSize = objinfo->objHdr.size;

			if((location = currentObjSize)>0)
				location = (int)random() % currentObjSize;

			switch(cmd) {
			case WORD_WRITE:
			case WORD_DELETE:
				if((nbytes = (int)(currentObjSize - location))>0)
					nbytes = (int)random() % nbytes;
				break;
			case WORD_CREATE:
				/* don't let the object get bigger than CAP */
				nbytes = (int)random() %  objSizeCap;
				break;
			case WORD_APPEND:
			case WORD_INSERT:
				/* don't let the object get bigger than CAP */
				nbytes = (int)random() %  (objSizeCap - location);
				break;
			default:
				nbytes = 0;
				break;
			}
			sprintf(InputLine, "random%s %d %d %d %d", 
				cmd2word(cmd), objnum, location, nbytes, howMany);
			break;
		}
		/* This is to get past the "randomxxxx" at the beginning
		 * of the InputLine, and (the real reason) to leave
		 * strtok in its proper state so generic_command
		 * can do next_commandarg(ELIPSES)
		 */
		echo(count, InputLine);
		(void) first_commandarg(Whitespace);

		switch(cmd) {
		case WORD_CRASH:
			crashserver_command();
			break;

		case WORD_SLEEP:
			intarg_command(cmd);
			break;

		default:
			if( generic_command(cmd, 
				NEED_OBJNUM | NEED_LOCATION | NEED_AMOUNT | OPT_HOWMANY) 
								!= esmNOERROR)
				return esmFAILURE;
		}
	}

	return esmNOERROR;
} /* random_operation() */

static int seed = 0;
void
print_seed()
{
	INFO
		"Seed is %d\n",seed
	ENDINFO
}
int
set_seed(char * val)
{
	char *arg = next_word(val, Whitespace);

	if(getnum(arg, &seed) == esmFAILURE) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
		return esmFAILURE;
	}
	srandom(seed);
	return esmNOERROR;
}

int
random_command(ELIPSES)
{
	/* [#operations]  [startObj] [endObj] */
	/* no startObj arg --> all
	 * startObj arg and no endObj --> 1
	 * startObj, endObj --> range
	 */

	int	numops, startObj, endObj, e=esmNOERROR;
	char 		*arg;
	
	arg = next_commandarg(Whitespace);
	if(arg) {
		if(getnum(arg, &numops) == esmFAILURE) {
bad:
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
		return esmFAILURE;
		}
	} else {
		numops = 1;
	}

	arg = next_commandarg(Whitespace);
	if(arg) {
		if(getnum(arg, &startObj) == esmFAILURE) {
			goto bad;
		}
		if(startObj > objUACount) {
			HANDLE_ERROR(CAUSE_ET, TREAT_NONFATAL, BAD_OBJ_NUM);
			return esmFAILURE;
		}
	} else {
		startObj = 0;
		endObj = objUACount;
	}
	arg = next_commandarg(Whitespace);
	if(arg) {
		if(getnum(arg, &endObj) == esmFAILURE) {
			goto bad;
		}
		if(endObj > objUACount) {
			HANDLE_ERROR(CAUSE_ET, TREAT_NONFATAL, BAD_OBJ_NUM);
			return esmFAILURE;
		}
	} else {
		endObj = startObj;
	}


	e = random_operation(numops, startObj, endObj);
	return  e;
}
