/*
 * $RCSfile: ovf.c,v $
 * $Revision: 1.6 $
 * $Date: 1993/05/03 15:21:13 $
 */
#include <stdio.h>
#include <stdlib.h>
#include "et.h"
#include "etError.h"
#include "func.h"

void
seektoObjects(int which, int caobj, int paobj)
{
	int offset = 8;

	switch(which) {
	case WORD_COMMIT:
		break;
	case WORD_PREPARE:
		offset += (caobj * sizeof (ObjInfo));
	}
	if (fseek(OVFPtr, offset, SEEK_SET) == -1) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
	}
	DEBUGINFO
		"seeked OVF to %d \n", ftell(OVFPtr)
	ENDINFO
}

void 
readOVF(int which, ObjInfo *array, int *numOfObj, FILE *OVFPtr)
{
	/* format of ovf file: int caobj, int paobj, caobjs, paobjs */
	int 	i, caobj, paobj;

	if((which != WORD_PREPARE) && (which != WORD_COMMIT)) {
		HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, OVF_ERR); /* internal */
	}
	DEBUGINFO
		"read OVF:\n"
	ENDINFO
	if(OVFPtr==NULL) {
		INFO
			"Null OVF"
		ENDINFO
		HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, OVF_ERR);
	}
	/*
	 *   Position the read mark to the location of where
	 *   the objects'info starts of OVF 	
	 */
	rewind(OVFPtr);
	
	if(fread(&caobj, sizeof(int), 1, OVFPtr) == 0) {
		/* empty file */
		*numOfObj = 0;
		return;
	}
	if(fread(&paobj, sizeof(int), 1, OVFPtr) != 1) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
	}
	*numOfObj = ((which == WORD_COMMIT)? caobj : paobj);
	DEBUGINFO
		"READING %d %s objects from OVF\n", *numOfObj, (which==WORD_PREPARE)?"prepared":"committed"
	ENDINFO
	seektoObjects(which, caobj, paobj);

	for (i = 0; i < *numOfObj; i++) {
	    if (fread((void *)&array[i], sizeof(ObjInfo), 1, OVFPtr) != 1) {
			HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
	    }
		if(debugon)
			printobj(i, &array[i]);
	}
	DEBUGINFO
		"END read OVF; found %d objects.\n",*numOfObj
	ENDINFO
}	

void 
writeOVF(int which, ObjInfo *array, int numOfObj, FILE *OVFPtr)
{	
	ObjInfo *objinfo;
	int		caobj, paobj;
    int 	i, destroyed = 0, undestroyed = 0;
	BOOL	skip_destroyed;

	DEBUGINFO
		"write OVF:\n"
	ENDINFO
	/*
	 * we re-write the #paobj and PA part
	 * OR
	 * we re-write #caobj, CA part, blow away PA part and write #paobj = 0.
	 * If we're doing the latter, we don't bother with the destroyed objects.
	 */
	if(OVFPtr==NULL) {
		INFO
			"Null OVF"
		ENDINFO
		HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, OVF_ERR);
	}
	/*debugging sanity check */
	check_no_temp_objects(array, numOfObj);

	/* count number of undestroyed objects */
	for (objinfo = array, i=0; i < numOfObj; i++, objinfo++) {
		if( objinfo->destroyed) {
			destroyed++;
		} else {
			undestroyed++;
		}
	}

	switch(which) {
		case WORD_COMMIT:
			skip_destroyed = TRUE;
			paobj = 0;
			caobj = undestroyed;
			break;
		case WORD_PREPARE:
			skip_destroyed = FALSE;
			paobj = numOfObj;
			rewind(OVFPtr);
			/* committed is whatever it was before */
			if(fread(&caobj, sizeof(int), 1, OVFPtr) == 0) {
				/* could have been empty file */
				caobj = 0;
			} 
			break;
		default:
			/* internal error */
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, OVF_ERR);
	}
	rewind(OVFPtr);
    if (fwrite((void *)&caobj, sizeof(int), 1, OVFPtr) != 1) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
    } 
    if (fwrite((void *)&paobj, sizeof(int), 1, OVFPtr) != 1) {
		HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
    } 
	DEBUGINFO
		"wrote to OVF: #caobj=%d, #paobj=%d\n", caobj, paobj
	ENDINFO
	seektoObjects(which, caobj, paobj);

    for (objinfo = array, i=0; i < numOfObj; i++, objinfo++) {
		if( (objinfo->destroyed) && skip_destroyed ) 
			continue; 
		if (fwrite((void *)objinfo, sizeof(ObjInfo), 1, OVFPtr) == 1) {
			if(debugon)
				printobj( i, objinfo);
		} else {
			HANDLE_ERROR(CAUSE_UNIX, TREAT_FATAL, OVF_ERR);
		}
    }
	INFO "\n\n" ENDINFO

	INFO 
		"From %d objects, wrote %d CA, %d PA (%d destroyed) successfully to OVF\n", 
		numOfObj, caobj, paobj, destroyed 
	ENDINFO
	fflush(OVFPtr);
}
