/*
 * $RCSfile: misc.c,v $
 * $Revision: 1.9 $
 * $Date: 1993/04/29 16:32:13 $
 */
#include <string.h>
#include <stdlib.h>

#include "et.h"
#include "etError.h"
#include "func.h"
#include <sys/socket.h>


char *ETERRORMSG[]={
	"malloc",			/* 0 */
	"OVF file",				/* 1 */
	"variable 'randop' is not set",	/* 2 */
	"end of file encountered",			/* 3 */
	"script file",	/* 4 */
	"stdin (pipe)",		/* 5 */

	"in initialization",				/* 6 */
	"sm_MountVolume",			/* 7 */
	"starting a new transaction",			/* 8 */
	"failed to commit the current transaction, OVF not updated.",	/* 9 */
	"sm_AbortTransaction.",		/* 10 */
	"sm_CreateFile or sm_DestroyFile",			/* 11 */
	"sm_SetRootEntry ",	/* 12 */
	"sm_ShutdownServer.",			/* 13 */
	"sm_ConnectToServer.",			/* 14 */
	"sm_CreateObject.",			/* 15 */
	"sm_DestroyObject of obj# ",			/* 16 */
	"failed to insert to obj# ",				/* 17 */
	"sm_AppendToObject to obj# ",			/* 18 */
	"sm_DeleteFromObject from obj#",		/* 19 */
	"failed to read object into buffer pool for obj# ",	/* 20 */
	"failed to read object header of obj# ",			/* 21 */
	"failed to release userDesc for obj# ",		/* 22 */
	"sm_FreezeVersion ",			/* 23 */
	"sm_CreateVersion",		/* 24 */
	"sm_SetObjectHeader to obj# ",		/* 25 */
	"inappropriate parameter, CANNOT write to obj# ",	/* 26 */
	"sm_CloseBufferGroup ",		/* 27 */
	"sm_DismountVolume ",			/* 28 */
	"sm_ShutDown ",			/* 29 */
	"sm_OpenBufferGroup ",			/* 30 */
	"checksum changed",	/* 31 */
	"no EVOLID environment variable ",		/* 32 */
	"bad object number ",		/* 33 */
	"taking check point.",			/* 34 */
	"changing check point frequency.",		/* 35 */
	"client-initiated crashServer operation.",	/* 36 */
	"sm_OpenScan",				/* 37 */
	"sm_ScanNextObject",				/* 38 */
	"sm_CloseScan",				/* 39 */
	"sm_ServerStatistics",				/* 40 */
	"Unrecognized command",				/* 41 */
	"Syntax error",				/* 42 */
	"Root entry length changed",	/* 43 */
	"Object already destroyed",	/* 44 */
	"Object number invalid",	/* 45 */
	"error in 2 phase commit",	/* 46 */
	"string too long",	/* 47 */
	"no such variable",	/* 48 */
	"can't close buffer group",	/* 49 */
	"can't open buffer group",	/* 50 */
	"No volumes given.",	/* 51 */
	"File has more objects than OVF",	/* 52 */
	"File has fewer objects than OVF",	/* 53 */
};

/********************************************************
 *
 * 	isDestroyed
 *
 *******************************************************/

BOOL isDestroyed(ObjInfo *objInfo, int cause)
{
	if (objInfo->destroyed == TRUE) {
		if(cause)
			HANDLE_ERROR(cause, TREAT_NONFATAL, SM_READ_OBJ_HEADER_ERR);
		return TRUE;
	}

	return FALSE;
}


/********************************************************
 *
 *  	varError	
 *
 *******************************************************/
BOOL varError(int argumentCount, int option1, int option2, int option3,
	int option4, int *objNum, int *location, int *amount, int *howMany)
{
	if (argumentCount >= 5)
		*howMany = option4;
	else if (argumentCount == 4)
		*howMany = 1;
	else
		return TRUE;

	*objNum = option1;
	*location = option2;
	*amount = option3;

	return FALSE;
}



/********************************************************
 *
 *  	handle_error 
 *
 *******************************************************/

static char *causeStrings[] = {
	"",
	"USER",
	"VALIDATION",
	"SM",
	"ET",
	"UNIX",
	0
};

BOOL StopReconnect = FALSE;
static int 	prev_cx_err_count = 0;
static int 	prev_cx_err = esmNOERROR;

void
clear_connect_error()
{
	prev_cx_err_count = 0;
	prev_cx_err = esmNOERROR;
}

void 
handle_error(
	int source,
	int treatment,
	int additionalinfo, 
	int line,
	char * file,
	BOOL do_checkStatus,
	VOLID volid,
	int  reconnect_tries)
{
	int 		errnum;


	switch(source) {
	case CAUSE_UNIX:
		errnum = errno;
		break;

	case CAUSE_VALIDATION:
		if(connection_error(errnum)) {
			/* a cx error should never be treated as a
			 * validation error 
			 */
			source = CAUSE_SM;
		}
		/* drop through */
	case CAUSE_SM:
		errnum = sm_errno ;
		break;

	case CAUSE_ET:
	case CAUSE_USER:
		errnum = 0;
		break;
	default:
		fprintf(stderr, "UNKNOWN CAUSE:%d\n", source); exit(1);
		break;
	}

	if( connection_error(errnum) && (prev_cx_err == errnum)) {
		prev_cx_err_count ++;
	} else {
		prev_cx_err_count = 0;
		prev_cx_err = errnum;
	}
	if(prev_cx_err_count > 0) {
		/* mpl connection errors in a row - don't repeat */
		if( (prev_cx_err_count % 10) == 0 ) 
			fprintf(stderr, " %d\n", prev_cx_err_count);
		else fputc('.', stderr);

		if( (reconnect_tries == 0) || (volid == 0) || StopReconnect )	{
			goto done;
		}
		if(connect2server(volid, reconnect_tries))
			goto done;
	}

	fprintf(stderr, "%s error ", causeStrings[source]);

	if(errnum) 
		fprintf(stderr, "%s : %s\n", 
			sm_ErrorId(errnum), sm_Error(errnum));
	if(errnum == esmTRANSABORTED) {
		fprintf(stderr, "reason : %s\n", 
			sm_ErrorId(sm_reason));
	}

	if(additionalinfo != NOINFO)
		fprintf(stderr, "%s\n",   ETERRORMSG[additionalinfo]);

	switch(source) {
	case CAUSE_USER:
		fprintf(stderr, "input line #%d: %s\n", InputLineNumber, InputLineSave);
		break;
	case CAUSE_SM:
	case CAUSE_ET:
	case CAUSE_VALIDATION:
		fprintf(stderr, "\tat line %d, file %s\n", line, file);
		break;
	default:
		break;
	}

	if( connection_error(errnum)  ) {
		if(tx_is_prepared) {
			/* need to continue */
			_continue2pc(TRUE);
		} else  if( (reconnect_tries > 0) 
			&& (volid != 0) && (!StopReconnect) )	{
			if( connect2server(volid, reconnect_tries) ) {
				goto done;
			}
		}
	}

	if( source == CAUSE_VALIDATION) {
		InvalidCount++;
	}

	switch(treatment) {
	case TREAT_FATAL:
		exit(source);

	case TREAT_NONFATAL:
		reportableProblems ++;
		break;

	case TREAT_INFO:
		break;
	}

done:
	if(do_checkStatus) {
		checkStatus(TRUE);
	} else if(errnum == esmTRANSABORTED) {
		/* TODO: not sure if we want to ignore the result of this: */
		(void) abort_tx(FALSE);
	}
	retry( errnum );
}


void printStats(BOOL addronly, SERVERSTATS *stats)
{
	if(addronly) {
		fprintf(stderr, "\nServer: %s.%d\n",  
		  inet_ntoa(*(struct in_addr *)(&stats->serverAddr.sin_addr.s_addr)),
		  ntohs(stats->serverAddr.sin_port));
		return;
	}
	/* sockaddr is in network byte order */
	fprintf(stderr, "\nSTATISTICS for Server: %s.%d\n",  
		  inet_ntoa(*(struct in_addr *)(&stats->serverAddr.sin_addr.s_addr)),
		  ntohs(stats->serverAddr.sin_port));
	fprintf(stderr, "Number of Clients: %d, Number of Volumes: %d\n",
		stats->numClients, stats->numVolumes);

	fprintf(stderr, "Transactions in progress: %d, Total Commits: %d, Total Aborts: %d\n",
		stats->numTrans, stats->totalCommits, stats->totalAborts);

	fprintf(stderr, 
		"Free Log Space: %d, Checkpoint Freq: %d\n", stats->freeLogSpace,
		stats->chpntFreq);

	/* sm_PrintMessageStats(stderr, stats->MsgStats); */
	fprintf(stderr,  "___________________________________________________________\n");
}

#if defined(mips) && defined(CHECKMALLOC)

int
checkMalloc(char *str, BOOL printChange)
{
	static int first = 1;
	static int lastchecked = 0;
	static int verbose = 0;
		
	if(first)  {
		lastchecked = mstats(str, printChange?1:0);
		first = 0;
	} else {
		int n = mstats(str,0);

		if(printChange) {
			if(n > lastchecked) {
				fprintf(stderr, "ALLOCED %d: ", n-lastchecked);
				mstats(str,1);
			} else if(n < lastchecked) {
				fprintf(stderr, "FREED %d: ", lastchecked-n);
				mstats(str,1);
			}
		}
		lastchecked = n;
	}
	return lastchecked;

}
#else
/* !defined(mips) || !defined(CHECKMALLOC) */

int  	checkMalloc(char *a, BOOL b) { return 0;}; /* not included */

#endif 
