/*
 * $RCSfile: formPattern.c,v $
 * $Revision: 1.4 $
 * $Date: 1993/05/03 17:07:09 $
 */
#include <string.h>
#include <math.h>
#include "et.h"
#include "func.h"

static char *buf = NULL;
static int	bufsize = 0;

void
freePatternBuf()
{
	if(buf != NULL) free (buf);
	buf = NULL;
}

char *formPattern(char *header, int id, int length)
{
	char 	*str;
	char	idStr[100];
    int     headerLen;
    int     idLen;
    int     strLen;

    sprintf(idStr, "%d", id);
    idLen = strlen(idStr);

    headerLen = strlen(header);

	if(length < (headerLen + idLen)) {
		length = headerLen + idLen;
	}

	if( length > bufsize) {
		if(buf) {
			free(buf);
			buf = NULL;
		}
		bufsize = 0;
	}
	if (buf == NULL) {
		buf = (char *) malloc(length);
		if(buf == NULL) {
			fprintf(stderr, "CANNOT MALLOC length %d\n", length);
			exit(1);
		}
		bufsize = length;
	}

	str = buf;
    strLen = 0;

    for (;;) {
		/* alternately copy header, then id */

        bcopy(header,str,headerLen);
        str += headerLen;
		strLen += headerLen;
		if(strLen >= length - idLen)  /* what we're going to copy next */
			break;

        bcopy(idStr,str,idLen);
        str += idLen;
		strLen += idLen;
		if(strLen >= length - headerLen)  /* what we'd copy next */
			break;
    }
	for(; strLen < length; strLen++, str++) {
		*str = 'z';
	}
	if(str - buf > length) {
		fprintf(stderr, "ASSERT FAILED\n");
		exit(1);
	}

    return buf;
}


