#ifndef _ET_H_
#define _ET_H_
/*
 * $RCSfile: et.h,v $
 * $Revision: 1.22 $
 * $Date: 1993/05/03 15:14:46 $
 */


/* 
 *  DEVELOPERS, NB: define BASELINE when you are
 *  compiling ET for use with the baseline.
 *  Use #ifndef BASELINE, etc. to hack in changes that
 *  are required to compile ET with your experimental versions
 *  of the SM.  When you check your changes into the baseline,
 *  remove the code that is specific to the old baseline.
 *  ALWAYS leave BASELINE defined in the checked-in version of et (et.h).
 */

#undef BASELINE


#include "sysdefs.h"

#include "sm_client.h"
#include "sm_staff.h"
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <netinet/in.h>

#if !(defined(hpux) || defined(linux))
extern "C" int strcasecmp(char *, char *);
#endif /* !(hpux || linux) */
extern "C" int bf_Stats(int *, int *, BOOL );

BOOL FakingFailure;

/* C case doesn't define this */
#ifndef SIG_PF
typedef void (*SIG_TYP)();
#endif

#ifdef __cplusplus
#define BEGIN_EXTERNC extern "C" {
#define END_EXTERNC }
#else
#define BEGIN_EXTERNC
#define END_EXTERNC
#endif __cplusplus

#define MAXOBJS 10000
#define MINOBJSIZE 10
#define MAXWRITE (30 * 4096) 

extern BOOL interactive;

#define PROMPT if(interactive) fprintf(stdout, "\n> ")
#define GETNEWLINE  getnewline()


/*
 * #define	OVFILE		"OVF" 
 * #define	FID_ROOT_ENTRY	"the data file"
 */
#define DEFAULTSIZE	50	

#define ARRAYSIZE	10000	/* size of UA and CA */ 
#define INPUTSIZE	800
#define COMMANDSIZE	30
#define	VARIABLESIZE	30
#define STRINGSIZE	100 
#define RANDSIZELIMIT	200 	/* random create, append, insert size 0-59 */
#define SLEEPDEFAULT	10	/* random sleep time 0-9 */
#define BUFPOOLPAGES	150	/* default buffer pool size and buffer group */
				/* size if they are not specified in the     */
#define MINBUFGROUPPAGES   20	/* 'session' command			     */ 
#define SERVERNAMELIMIT 10	/* 10 server port numbers can be specified   */
				/* in ESERVERNAME			     */
#define SERVERNAMESIZE  15	/* the number of chars for each server port  */
				/* name specified in ESERVERNAME	     */


typedef struct {
	int 	index;
	BOOL	destroyed;
	OID		objID;
	int		checkSum;
	OBJHDR  objHdr;
	int		parentONum;
	BOOL 	visited;
}  ObjInfo;

typedef char OPERATION[10];


struct varEntry {
	char	name[VARIABLESIZE];
	char	itstring[STRINGSIZE];
	struct varEntry  *nextVar;
};
extern char	varString[];
typedef struct varEntry VarType;
extern VarType		*lastVarPtr;

extern FILE		*OVFPtr;	
#ifndef BASELINE
extern BOOL AutoMount;
#endif

#define NUMOFRECONNECT	15 
extern	int 	Numretries;
extern	TID		tid;
#define NO_BUFGROUP -1
extern int		bufGroup;
extern	int     InvalidCount;
extern char		rootEntryName[];
extern 	FID		Fids[];
typedef struct volidInfo {
	VOLID 	volid;
	TID		lastused; /* last-tx used */
	int		crashloc;
	BOOL	temp;
	BOOL	empty;
	BOOL	connected;
	VOTE	vote;
} VOLIDINFO	;
extern  BOOL	StopReconnect;
extern 	VOLIDINFO	Volids[];
extern  int		Nvolumes;
extern 	int		objSizeCap;
extern	ObjInfo         UA[ARRAYSIZE];
extern  ObjInfo         CA[ARRAYSIZE];
extern int		objUACount;
extern int		objCACount;
extern BOOL		DestroyDataFiles;
extern int		InputLineNumber;
extern char		InputLine[];
extern char		InputLineSave[];
extern char		*argv0;
extern char	 	*Whitespace;
extern	VarType	*currentVar;
extern	BOOL tx_is_prepared;
extern BOOL		multiportHack;

#define NEED_OBJNUM 	0x1
#define NEED_LOCATION 	0x2
#define NEED_AMOUNT 	0x4
#define OPT_HOWMANY 	0x8

#define GET_COMMAND_ANY 1
#define GET_COMMAND_SESSION	2
#define GET_COMMAND_ENDTX	3

/*
 * These are constants to identify words
 * (We don't want the constants to depend on the location of the
 * command in the table in ET_scan.c.)
 */
#define WORD_NONE 	-1
#define MIN_WORD 5000

#define WORD_CLIENTOPTION 5000
#define WORD_CONFIGFILE 5001
#define WORD_SESSION 5002
#define WORD_COMMIT 5003
#define WORD_CREATE 5004
#define WORD_APPEND 5005
#define WORD_CONNECT 5006
#define WORD_CHECKPOINT 5007
#define WORD_DESTROY 5008
#define WORD_DELETE 5009
#define WORD_ECHO 5010
#define WORD_EXIT 5011
#define WORD_STDOUT 5012
#define WORD_STDERR 5013
#define WORD_FLUSH 5014
#define WORD_FREQUENCY 5015
#define WORD_HELP 5015
#define WORD_INSERT 5017
#define WORD_LIST 5018
#define WORD_NOECHO 5019
#define WORD_PRINT 5020
#define WORD_RANDOM 5021
#define WORD_TRANSACTION 5022
#define WORD_USED 5023
#define WORD_ALL 5024
#define WORD_RANDOP 5025
#define WORD_READ 5026
#define WORD_SCAN 5027
#define WORD_SET 5028
#define WORD_SERVER 5029
#define WORD_SLEEP 5030
#define WORD_VALIDATE 5031
#define WORD_RESET 5032
#define WORD_UA 5033
#define WORD_CA 5034
#define WORD_VERSION 5035
#define WORD_WRITE 5036
#define WORD_PREPARE 5037
#define WORD_ENTER 5038
#define WORD_SERVERVAR 5039
#define WORD_RECOVER 5040
#define WORD_CRASH 5041
#define WORD_ABORT 5042
#define WORD_SEED 5043
#define WORD_TID 5044
#define WORD_VOLID 5045
#define WORD_OBJSIZELIMIT 5046
#define WORD_CONTINUE 5047
#define WORD_SYNC 5048
#define WORD_SPACE 5049
#define WORD_LOGLEVEL 5050
#define WORD_ADD 5051
#define WORD_RM 5052
#define WORD_NADA 5053

#define MAX_WORD 5053
#endif /* _ET_H_ */
