.po 1.0i 
.ll 6.5i 
.ps 14
.vs 16
.ce 3
.sp 1.0i 
.B
\fBEXODUS Version 2 Tester (ET) Documentation\fR
.ps 12
.vs 14
.sp 6p
\fIZack Zheng Xu\fR
.br
(December, 1991)
.br
.sp 0.3i
.pp
.ps 13
.vs 15
.B
\fB1. What is ET?\fR
.sp 0.2i 
.ps 12
.vs 15
	ET (EXODUS Tester) is a testing program for the EXODUS Storage Manager.
It simulates a client making requests to the server, performing transactions,
manipulating data objects, and being able to validate data consistency and
recovery after a server or client crash.  A command set is supported.  It is
a simple user-level testing language.  Its commands can be run interactively
or in scripts.
.sp 10p
	ET is an effective tool for "black box" testing.  Only a knowledge
of the ET command set is needed to use the Storage Manager, whose 
\fIfunctions\fR can be tested.  The server is treated as a "black box". 
The input to the
server is the client requests made when ET runs a series of predesigned
or random commands.  The output of the server, error messages and validation
results, indicates its status.  The error messages are used to trace bugs
in the source code if any server malfunction or data inconsistency occurs.
ET can also be used for "white box" testing, scripts can be written to
test specific \fIinternal structures\fR of the Storage Manager if the
tester is aware of the implementation.
.br
.sp 0.3i
.pp
.ps 13
.vs 15
.B
\fB2. ET's Command Set\fR
.sp 0.2i 
.ps 12
.vs 15
\fB2.1 Starting ET\fR
.sp 10p
	Before running ET, you need to set the environment variable EVOLUME
which gives the default disk volume (\fBsetenv EVOLUME volumeName\fR), and
ESERVERNAME which gives the port numbers through which the client will be
connecting to the server (\fBsetenv ESERVERNAME "portNum1 portNum2..."\fR).
The command to start ET is 
.br
.sp 8p
\fB		et [scriptFileName]\fR
.br
.sp 8p
a script file name needs to be given if commands are taken from a script. 
.sp 0.2i
\fB2.2 Syntax of ET Commands\fR
.sp 10p
\fB		session [-f fileRootEntry] [-v volName] [-b bufGroupPages]\fR
.sp 7p
A session command must precede all other commands.  It calls sm_Initialize(),
and initializes the environment and the data structures needed for a
client session.  The parameter \fBfileRootEntry\fR is the data file root entry,
which uniquely identifies a data file.  If it is not given, "default" is used.
The disk volume to be used can be specified by \fBvolName\fR, which overrides
EVOLUME if given.  The parameter \fBbufGroupPages\fR specifies the client
buffer group size in terms of a number of 4 Kbyte pages, if not given,
a default value of 20 pages is used.
.bp
.sp 1.0i 
\fB		create numOfBytes [howMany]\fR
.sp 7p
It creates an object of size \fBnumOfBytes\fR; more than one object of the same
size can be created if \fBhowMany\fR is given.  Each object created is
assigned a unique
object number, which is used to index into UA and CA (UA: Uncommitted Array,
CA: Committed Array, see section 3 for more details) where an entry is
initialized for each newly created object.
.sp 11p
\fB		destroy objNum [howMany]\fR
.sp 7p
The specified object is destroyed.  If \fBhowMany\fR is given, a number
of objects will be destroyed starting from the one with \fBobjNum\fR. 
.sp 11p
\fB		insert objNum location numOfBytes [howMany]\fR
.sp 7p
A pattern of size \fBnumOfBytes\fR is inserted into the specified object
at the given location.  A procedure is called to generate the pattern,
e.g. I0I0I0I0I0.
Similarly, this can be done to more than one object if \fBhowMany\fR is given.
.sp 11p
\fB		append objNum numOfBytes [howMany]\fR
.sp 7p
A pattern of size \fBnumOfBytes\fR is appended to the specified object. 
.sp 11p
\fB		write objNum location numOfBytes [howMany]\fR
.sp 7p
A pattern of size \fBnumOfBytes\fR overwrites the region of bytes starting
at \fBlocation\fR in the specified object.
.sp 11p
\fB		delete objNum location numOfBytes [howMany]\fR
.sp 7p
A region of bytes of size \fBnumOfBytes\fR starting from \fBlocation\fR
is deleted from the specified object.
.sp 11p
\fB		read objNum [howMany]\fR
.sp 7p
The specified object is read into the client buffer group, it is then
printed to the standard output together with some properties e.g. object
size and versioning status.  If all objects of the data file
need to be read, use \fBscan\fR command.
.sp 11p
\fB		version objNum\fR
.sp 7p
A version of the specified object is created.  The original object must
be frozen first, then it can no longer be modified.  The new version is
an exact copy of the original object, it is also assigned an object number. 
.sp 11p
\fB		validate ua (or ca) [objNum] [howMany]\fR
.sp 7p
The state of the specified object is validated, its check sum (more
on check sum is discussed in section 3), size, tag and properties are
compared with the corresponding information stored in
.br
.bp
.sp 1.0i
UA or CA, all discrepancies are reported to the standard output.
To validate, either \fBua\fR or \fBca\fR \fImust\fR be specified.
UA is Uncommitted Array, and CA is Committed Array, they are the data
structures maintained by ET specifically for object validation.
If no object number is given, all objects of the data file are validated. 
\fBValidate\fR command is an important feature of ET since it ensures and
checks for data consistency. 
.sp 11p
\fB		set variableName = string\fR
.sp 7p
Variables can be used with the ET commands.  All characters after "=" 
before a newline
are stored and associated with the variable name.  To use
a variable, a "$" character must be prefixed to its name indicating
it is a variable.  The variable name is replaced with its value
- a character string before the command line is interpreted.  A variable
can be reassigned a value.  The following is an example of using variables:
.br
.sp 6p
	set objectSize = 100
.br
	set numOfObj = 20
.br
	create $objectSize $numOfObj
.sp 11p
\fB		random seed [numOfOperations] [objNum] [howMany]\fR
.sp 7p
Before running any random operations, the variable \fBrandop\fR must be set.
It specifies what random operations are to be executed.  More on random
operations is discussed in section 4.  A random seed must be supplied
to produce one or a series of random operations.  The random seed can be
used to reproduce the exact random operations if desired (provided
\fBrandop\fR remains the same).  The parameter,
\fBnumOfOperations\fR, specifies how many random commands are
to be generated, default value is one.  Random operations can be run on a 
specific object, or a range of objects. 
.sp 11p
\fB		serverstats [reset]\fR
.sp 7p
Some statistics about the current state of the server are printed.
They include the number of the mounted volumes, the number
of clients connected, the number of transactions committed and aborted.
If "\fBy\fR" is given following \fBserverstats\fR, all statistical
counters are reset to zero.
.sp 11p
\fB		endechofile\fR
.sp 7p
Commands being executed through ET can be saved into a file called echo file.
This is useful during interactive testings or when running random operations.
The echo file can be run
later as an ET script file.  To start echoing, variable \fBechoFile\fR needs 
be set to the echo file name: \fBset echoFile = echoFileName\fR.
All ET commands and comments (a line started with a "#" character) are
then written to the echo file, until a command \fBendechofile\fR is encountered.
The echo file is appended, so echo can be stopped and then resumed
later.  More than one echo file can be used during an ET session,
but each command or comment can be written to only one echo file.
.bp
.sp 1.0i
\fB		list\fR
.sp 7p
The command \fBlist\fR lists all the ET variables and their values. 
.sp 11p
\fB		scan\fR
.sp 7p
All objects of the data file are scanned: their object number, byte value
and size are printed to standard output.
.sp 11p
\fB		flush\fR
.sp 7p
Client flushes the dirty pages in its buffer out to the server.
.sp 11p
\fB		checkpoint numOfCheckpoints\fR
.sp 7p
Client sends a request to the server to take a certain number of
checkpoints.
.sp 11p
\fB		frequency numOfRecords\fR
.sp 7p
Client sends a request to the server to change the frequency of checkpoints.
By default, a checkpoint is taken every 5,000 log records.
.sp 11p
\fB		print UA (or CA)\fR
.sp 7p
UA or CA is printed to the standard output.  This is useful in interactive
testings for comparing the properties stored in UA or CA to those in the
object header.
.sp 11p
\fB		echo (or noecho)\fR
.sp 7p
The commands in a script file can be printed to the standard output
during execution.  \fBnoecho\fR terminates it.
.sp 11p
\fB		commit\fR
.sp 7p
Client commits its current transaction.
.sp 11p
\fB		abort\fR
.sp 7p
Client aborts its current transaction.  Any transaction that does not get
committed will be aborted; this is the case when either the server
or the client dies during a transaction.  
.sp 11p
\fB		sleep seconds\fR
.sp 7p
Client sleeps for a number of seconds.  This can be put in scripts so
commands can be run intermixed with sleeps. 
.sp 11p
\fB		crashServer\fR
.sp 7p
Client issues a request to crash the server.  This is a privileged
command, but since this is a testing program, it is allowed. 
.bp
.sp 1.0i
\fB		connect [numOfTimes]\fR
.sp 7p
If a client detects the death of the server, it can try to reconnect
to the server.  The current transaction is aborted before doing so. 
If it is already connected to the server, then a new transaction is
immediately started.  The parameter, \fBnumOfTimes\fR, specifies how
many times the
client should try to reconnect.  A few seconds of sleep is included
between each try.  If \fBnumOfTimes\fR is not given, a default value
of 10,000 is used (try to reconnect for about 14 hours).
This command is only useful in scripts when
the client knows in advance when the server crashes (as 
in the case when client itself crashes the server with \fBcrashServer\fR).
.sp 11p
\fB		#\fR
.sp 7p
Comments can be used in scripts or interactively.  Any line starting with
a "\fB#\fR" character is regarded as a comment.
.sp 11p
\fB		exit\fR
.sp 7p
Client ends the ET session: the current transaction is committed; UA
overwrites CA, then CA gets written to the OVF (see section 3); client
buffer group gets closed; disk volume gets unmounted; then sm_ShutDown()
is called.
.br
.sp 0.3i
.pp
.ps 13
.vs 15
.B
\fB3. Object Validation\fR
.sp 0.2i 
.ps 12
.vs 15
	For object validation, two static arrays (it can be implemented
dynamically in the future) are maintained during an ET session to keep
updated information of the objects in the data file.  They are Committed
Array (CA) and Uncommitted Array (UA).  A UNIX file called The Object
Validation File (OVF) is also maintained for each data file.  It retains
information of the objects in their current state from session to session. 
.br
.sp 10p
	When an ET session begins, if the data file is new and to be created,
a corresponding OVF is also created, it is named with the data file root
entry name suffixed with ".ovf". If the data file has already existed, the 
information is loaded from the OVF into UA and CA.  For each object
(all existing
ones and those that have been destroyed in the past),
there is an entry indexed with the object number in UA and CA.  The structure
of the entry is as follows:
.sp 6p
	typedef struct {
.br
		BOOL		destroyed;	/* TRUE if the object has been destroyed */ 
.br
		int		objNum;	/* object number, also the index into UA and CA */ 
.br
		OID		objID;		/* a unique OID identifying the object */
.br
		int		checkSum;	/* check sum of the object, for validation */
.br
		OBJHDR	objHdr;	/* a copy of the object header is kept */ 
.br
		int		parentONum;	/* parent object number if it is a version object */
.br
	}  ObjInfo;
.bp
.sp 1.0i
The difference between UA and CA is that CA keeps information of all the
\fIcommitted\fR transactions, and UA is updated after each operation to
an object (e.g. insert, write, version, create, delete)
in the \fIcurrent\fR transaction.  When a transaction is
committed, UA overwrites CA, and CA gets written out to the OVF; when
a transaction is aborted, CA overwrites UA.
.sp 10p
	An integer check sum is kept for each object, instead of the object
itself being stored in UA or CA.  The check sum is computed as follows:
.br
.sp 6p
.ps 14
.vs 17
\fB		C  =  \(*S
.ps 12
.vs 15
a
.ps 14
.vs 17
\ + \(*S
.ps 12
.vs 15
(a  \(mu  p)\fR
.br
.sp 6p
\fBa\fR is the ASCII value of a byte (character), \fBp\fR is the position of the
byte within the object.  Although it is possible for an object to be changed
(corrupted) while keeping the same check sum, the probability of this happening
is very low.  When an object is changed by the client, its check sum is
recomputed and saved in UA.  During validation, an object is read into the
client buffer, its check sum is computed and compared with the one kept in
CA (or UA).
.br
.sp 0.3i
.pp
.ps 13
.vs 15
.B
\fB4. Using ET\fR
.sp 0.2i 
.ps 12
.vs 15
\fB4.1 Random Operations\fR
.sp 10p
	Random operations can be done to an object or to a range of objects.
The advantages of running random operations are: \fB1.\fR a large number of
operations can be generated and executed efficiently (in short
amount of time)
\fB2.\fR client can be
running random operations for long period of time (e.g. overnight) without
human supervision.  Random testing is an inexpensive mechanism in software
testing, it has been used to test operating system utilities [1] and network
protocols.  It is effective for stress testing [2] on the server, and helps
make more rigorous and complete testings possible.
.sp 10p
	Currently, the following commands can be run as random operations:
\fBcreate, destroy, delete, insert, append, write, version\fR and \fBsleep\fR.
Any subset of them can be run together, variable \fBrandop\fR must be set
before any use of \fBrandom\fR command, so ET knows what random operations
to run, e.g. \fBset randop = create insert append write sleep\fR.
It has been implemented that only legal random commands are generated,
e.g. operations on a non-existent object will not occur.  However, it would
also make sense to allow random commands with illegal parameters, a reasonable
response is still expected from the server [1].
.sp 10p
	Variable \fBsleep\fR can be set to a positive integer, so random
sleep times are ranged
from 0 to \fBsleep\fR-1. A default value of 10 seconds is used if it is not set.
A client can randomly sleep when it runs random operations, so random
requests can be made at random time to the server.
.sp 0.2i
.ps 12
.vs 15
\fB4.2 Multi-Client and Multi-Volume Tests\fR
.sp 10p
	Multiple ETs can be run simultaneously making requests to the server.
This increases the load on the server, and tests its ability to handle multiple
clients.  The ETs can be run interac-
.bp
.sp 1.0i
tively (in different windows) or in
scripts or in a combination of both.  The use of random sleeps helps produce 
asynchronous client requests.  But the occurrences of malfunction may depend
on the timing of the client requests, this adds a level of difficulty for
bug-fixing.  Currently, the testings have been limited to each client working
on its own data file, which is \fIexclusively\fR accessed and manipulated
by \fIonly one\fR client.  Mutual exclusion on each data object or even on the
level of bytes needs to be maintained to ensure data consistency
and to prevent deadlocks.  A good concurrency control mechanism is
unknown to access a UNIX file by more than one process.  This is crucial
if multiple clients simultaneously write out data to one OVF. 
Testings of this nature is much more complicated.
It is questionable if ET is up to the task.
.sp 10p
	Data files can reside on different user volumes, accessed and
manipulated by different clients through the server.  The disk volume
can be set in environment variable EVOLUME, or given as an option to the
\fBsession\fR command.
Again, a client can only access one data file at a time, so it can only
use one disk volume.  But different clients can use different volumes.
A separate log volume is always kept for logging by the server.
.sp 0.2i
.ps 12
.vs 15
\fB4.3 What If the Server Crashes? \fR
.sp 10p
	If ET is run interactively, and the server crashes and
aborts the current client transaction, the tester can decide to terminate
ET or to try to reconnect.  But what if a large \fIscript\fR is run overnight,
and the server dies and then restarts?  ET is implemented to handle
this case: while a script is being run, if the server death is detected by ET, 
ET automatically aborts the current transaction and tries to reconnect to
the server.  Once connected, a new transaction is started, but the script
commands of the \fIprevious\fR transaction, which has been unexpectedly aborted 
by the server, will be reexecuted (the exception is 
when \fBcrashServer\fR has been called in the previous transaction).
So if you are running a long script file overnight, you can be sure
that all commands in the
script file will be executed from the beginning to the end even if the server
crashes (as long as it comes back), and all intended operations will be
performed.
.br
.sp 0.3i
.pp
.ps 13
.vs 15
.B
\fB5. Limitations of ET\fR
.sp 0.2i 
.ps 12
.vs 15
	ET is a software testing tool for the EXODUS Storage Manager.  It is
also an experiment in testing database systems.  Clearly, ET does have
limitations.  First of all, the ET command set is simple, direct and easy
to learn, but it certainly lacks many features of a programming language,
e.g. no loops, no conditional branches.
But then, when those features are needed, a C testing
program can be written instead of using ET.  Secondly, ET does not fit
for complete
"white box" testing, since many internal features of the implementation are
hidden and not touched by ET.  In the end, ET is only a testing tool to help 
locate bugs, it was not designed to be an application program to use the
EXODUS Storage Manager.
.bp
.ps 13
.vs 15
.sp 1.0i 
\fB6. References\fR
.sp 0.2i 
.ps 12
.vs 15
[1]	B. P. Miller, L. Fredriksen, and B. So, "Study of the Reliability
of UNIX Utilities,"
.br
	\fICommunications of the ACM\fR, Vo. 33, No. 12 (December 1990)
.sp 8p
[2]	B. Beizer, \fISoftware System Testing and Quality Assurance\fR,
New York: Van Nostrand
.br
	Reinhold, 1983

