#!/bin/csh -f 
set loquacious
# set loquacious=1
set debug
#set debug=1
if ($loquacious)then
	echo NOTQUIET
endif 
#  set loquacious for not verbose
#  set loquacious=anything for verbose
set nonomatch
set targs="-tw"
#
# Step 1: check arguments
#
if ($#argv < 2) then
	echo "usage:" $0 'awkscript' 'files'
	exit 1
endif 
set awkscript=$1
shift
set flist
foreach i ($*)
	if ($loquacious) then
		echo $i
	endif 
	if (-f $i) then
		set flist=($flist $i)
	else
		echo $i is not a file.
		echo echo "usage:" $0 'files'
		exit 1
	endif 
end
if ($#flist < 1) then
	if ($loquacious) then
		echo Done.
	endif 
	exit(0)
endif 
# Step 2: Get typedef, define,  and function tags with ctags
#    first, save old tags file
#
	if (-f tags) then
		mv tags tags.bak
	endif 
	if ($loquacious) then
		echo  ctags $targs -f tags $flist
	endif 
#  get new tags
	ctags $targs $flist
	if ($debug) then
		ll tags 
		set ok=$<
	endif 
#
# Step 3: Add tags for #defines and struct definitions
#
#
	if ($loquacious) then
		echo "Finding #defines and structure definitions..."
	endif 
#
# 	use an awk script for finding the #defines and struct def'ns
#   structclass.awk
#
	foreach i ($flist)
	awk -f $awkscript $i | sed -e 's/\\	/	/g' >> tags
	end
	if ($debug) then
		ll tags
		set ok=$<
	endif 
#
#  Step 4:	Remove any duplicate lines and sort the file.
#	The original way sorts to remove duplicate lines and sort; 
#	then awks to remove duplicate definitions. Probably not necessary.
#
#	WARNING: do not mess with the sort commands.  Sort is so broken 
#   that we have to do it this way... until sort is fixed.
#
	if ($loquacious) then
		echo Removing duplicate definitions...
	endif 
#	would like to do: sort -u -otags tags ... but ... instead we do...
	sort -u tags > tags.sorted
#	Get rid of multiple definitions:
	awk 'BEGIN { FS="	"; prev="=" } { if ($1 != prev) { print; prev = $1 } }'\
		tags.sorted > tags
	rm tags.sorted
	if ($debug) then
		ll tags
		set ok=$<
	endif 

# 	Whew.
