#ifndef __SYSDEFS_H__
#define __SYSDEFS_H__
/*
 *   $RCSfile: sysdefs.h,v $  
 *   $Revision: 2.15 $  
 *   $Date: 1993/08/16 21:45:15 $      
 */ 

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#ifndef __ESS_H__
/* This file uses PROTO and BEGIN_EXTERNC from ess.h */
#include "ess.h"
#endif __ESS_H__

#if	defined(hpux)
	/* ess.h defines MIN and MAX which hpux already defines */
#	undef MIN
#	undef MAX
#endif

/* 
 * ANSI C ********** *****************************************************
 *                                                                       *
 *                                                                       V
 */
#include <ctype.h>
#include <errno.h>
#include <limits.h>

#ifdef FLT_MAX
/* grot - certain include files are NOT __STDC__:
 * FLT_MAX is supposed to be defined in <float.h>, but some broken
 * include files have it in <limits.h> as well.
 */
#undef FLT_MAX
#endif

#include <limits.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>

#if defined(hpux)
#	define BCOPY(a,b,c) bcopy((char*)a, (char*)b, c) 
#	define BZERO(a,b) bzero((char*)a, b) 
#elif defined(sgi)
#	include <bstring.h>	/* bcopy prototypes */
#else 
#	define BCOPY bcopy 
#	define BZERO bzero 
#endif

#include <time.h>

/* var args stuff: */
#include <stdarg.h>

/* some standard types, like size_t, as required by ANSI C */
#include <stddef.h>

/* C library */
#include <stdlib.h>

/* 
 *                                                                       ^
 *                                                                       *
 *                                                                       *
 * end of ANSI-C ********** **********************************************
 */

/*
 * types needed for system calls and just about everything else
 */
#include <sys/types.h>

/*
 *
 * handling of NULL ********************************************************
 *  
 * NULL is defined all over the /usr/include/*.h files, and its definitions
 * aren't necessarily the same!
 * So... before we use it, we'll undef it and redefine it here.
 *
 */
#ifdef NULL
#	undef NULL
#	define NULL 0
#endif

/* 
 * system calls **********************************************************
 * ATT C++ uses sysent.h but g++ does not.								 *
 * ATT C++ has sys/uio.h but g++ does not.								 *
 * g++ and cc use unistd.h, which doesn't necessarily include ALL 		 *
 * sysents.																 *
 * What's really disgusting is that unistd has read,write,close, but not *
 * open!!!!  															 *
 * open() is in fcntl.h for g++; it's in systent.h for ATT				 *
 * so ... we include <fcntl.h> for everyone. 							 *
 * Now, the unfortunate thing about that is that for cc & ATT C++,		 *
 * fcntl.h 	includes <sys/file.h> but g++ does not, so we include 		 *
 * it here for 	 consistency. 											 *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       V
 */


#if defined(__cplusplus)
#	if !defined(__GNUC__) 
#		include <sysent.h>
#		if defined(sgi)
		BEGIN_EXTERNC
			int writev(int, const struct iovec *, int);
		END_EXTERNC
#		endif
#	else
#		include <sys/file.h>
#		include <unistd.h>
#		define writev 	_______writev
#		define readv  	_______readv
#		include "/usr/include/sys/uio.h"
#		undef writev 
#		undef readv


		BEGIN_EXTERNC
			int readv(int, const struct iovec *, int);
			int writev(int, const struct iovec *, int);
		END_EXTERNC
#	endif 
#else
#	include <unistd.h>
#endif 

#include  <fcntl.h>

/* 
 * these two include files had better be protected against
 * double inclusion:
 */
#if	defined(hpux)
	/* sys/wait.h is included later due to interference in ipc.h */
#else
#	if defined(sgi)
	/* sgi has ptrace defined in osfcn.h ! */
#	else
#		include <sys/wait.h>
#	endif
#endif

#include <sys/ptrace.h>
#include <sys/time.h>


/*
 * getrusage() and setlinebuf() for hpux
 * GROT
 */
#if	defined(hpux)
#	include <sys/syscall.h>
#	define getrusage(a, b)  syscall(SYS_GETRUSAGE, a, b)
#	define setlinebuf(fp)	 (setvbuf(fp, NULL, _IOLBF, 0), 0)
#endif /* hpux */

/*
 * getdtablesize doesn't seem to be defined for hpux or sgi
 */
#if	defined(hpux) || defined(sgi)
#	define DTABLESIZE _POSIX_OPEN_MAX
#else
#	define DTABLESIZE getdtablesize()
#endif

/* 
 *                                                                       ^
 *                                                                       *
 *                                                                       *
 *                                                                       *
 * end of system calls      **********************************************
 */



/* 
 * net-related stuff *****************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       V
 */

#include <sys/socket.h>
#include <sys/ioctl.h>
#if	defined(hpux)
#include <sys/bsdtty.h>
#endif
#include <sys/uio.h>

#if (defined(__GNUC__) && defined(__cplusplus)) && (!defined(hpux)) && defined(mips)
#   define htons htons_c
#   define htonl htonl_c
#   define ntohs ntohs_c
#   define ntohl ntohl_c
#endif

#include <netinet/in.h>

#if defined(__GNUC__) && defined(__cplusplus) && !defined(hpux)
	BEGIN_EXTERNC
#		include <arpa/inet.h>
	END_EXTERNC
#else
	/* cc, cfront, and hpux compilers */
#	include <arpa/inet.h>
#endif

#include <netdb.h>


/* 
 * ATT C++ has prototype FUNCTION definitions for these (not macros).
 * G++ ends up including c version of in.h, which gives
 * us wrong definitions of the macros (no argument).  
 * This kludge gets us around that.
 * 
 * HP-UX already has these.
 */
#if (defined(__GNUC__) && defined(__cplusplus)) && !defined(hpux)

#undef htons 
#undef htonl 
#undef ntohs 
#undef ntohl 

#	ifdef _AIX
#		define _shorttype_ short
#		define _longtype_  long
#	else
#		define _shorttype_ u_short
#		define _longtype_  u_long
#	endif

BEGIN_EXTERNC
		_shorttype_		htons(_shorttype_);
		_shorttype_		ntohs(_shorttype_);
		_longtype_		htonl(_longtype_);
		_longtype_		ntohl(_longtype_);
END_EXTERNC
#endif

/* 
 *                                                                       ^
 *                                                                       *
 *                                                                       *
 *                                                                       *
 * end of net-related stuff **********************************************
 */


/* 
 * getopt(3) *************************************************************
 *                                                                       *
 *                                                                       *
 * MIPS:                                                                 *
 * This stuff is defined in the (ATT,GNU) C++ <stdlib.h>                 V
 * but not in the C <stdlib.h>.
 * This is the only case in which we try to compile with C,
 * since this is the arch for which we have a C compiler that
 * knows about prototypes.
 *
 * SPARCS:
 * in <stdlib.h> for both gnu and ATT
 * but not in C <stdlib.h>
 *
 * BSD:
 * defined in C <stdlib.h>
 * defined in ATT C++ <stdlib.h>
 * (no g++ include files installed yet)
 *
 * AIX:
 * defined in C <stdlib.h> under #ifdef _XOPEN_SOURCE
 * not defined in any C++ include files.
 */
#ifndef __cplusplus
	extern int getopt PROTO((int, const char* [], const char*));
#endif
extern char *optarg;
extern int optind, opterr;

/* 
 *                                                                       ^
 *                                                                       *
 *                                                                       *
 *                                                                       *
 * end of getopt(3) ******************************************************
 */

/* 
 * SYS V shared memory ***************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       V
 */


#if (defined(__GNUC__)||defined(BSD_MAKE)) && !defined(hpux)


/* Gnu library (except on hpux) doesn't have any of the SYS V shared memory stuff */

#include "/usr/include/sys/ipc.h"

#define shmget __shmget
#define shmat __shmat
#define shmctl __shmctl
#define shmdt __shmdt

#	if	defined(sparc)
#		define KERNEL
#		include "/usr/include/sys/shm.h"
#		undef KERNEL
#	else
#		include "/usr/include/sys/shm.h"
#	endif

#undef shmget 
#undef shmat
#undef shmctl
#undef shmdt

BEGIN_EXTERNC
	int shmget PROTO((key_t, int, int));
	char *shmat PROTO((int, void*, int));
	int shmctl PROTO((int, int, struct shmid_ds *));
	int shmdt PROTO((const void*));
END_EXTERNC
#define semctl ______semctl
#define semget ______semget
#define semop ______semop

#include "/usr/include/sys/sem.h"

#undef semget
#undef semop
#undef semctl

#if	defined(mips)
	/* g++ on mips does not have semun defined */
	union semun {
		int val;
		struct semid_ds *buf;
		ushort *array;
	}; 
#endif

BEGIN_EXTERNC
	int semget PROTO((key_t, int, int));
	int semctl PROTO((int, int, int, union semun));
	int semop PROTO((int, struct sembuf *, int));
END_EXTERNC


#else

/* the NORMAL way! */

#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

#endif 
/* 
 *                                                                       ^
 *                                                                       *
 *                                                                       *
 *                                                                       *
 * end of SYS V shared memory  *******************************************
 */


/*
 * This has to be included AFTER ipc, SYS V shared mem stuff (grot)
 */
#if	defined(hpux)
#	include <sys/wait.h>
#endif /* hpux */

#endif __SYSDEFS_H__
