#ifndef __POOL_H__
#define __POOL_H__
/*
 *   $RCSfile: pool.h,v $  
 *   $Revision: 2.8 $  
 *   $Date: 1992/11/27 19:17:28 $      
 */ 

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	define the forward declaration
 */
typedef struct _Pool	POOL;


/*
 *	define a type of function that takes a link and a message parameter
 */
#ifdef __cplusplus

	typedef char *(*ALLOCFUNC)(POOL *);

#elif defined(c_plusplus)

	typedef char *(*ALLOCFUNC)(POOL *);

#elif !defined(__cplusplus)

	typedef char *(*ALLOCFUNC)();

#else
	source code error
#endif


/*
 *	This defines the general structure of linked lists
 *	that will be used throughout the storage manager
 */

typedef struct _Pool {

	LIST		freeList;
	ALLOCFUNC	allocMore;
	FOUR		elements;
	FOUR		currentUsed;
	FOUR		maxUsed;
	MAGIC		magic;

};


/*
 *	Define the magic number for pools
 */
#define POOLMAGIC		0x34516780


/*
 *	define the magic number check routine */
#if LIST_CHECKING IS_ENABLED


#define CHECK_POOL_MAGIC(_element)							\
															\
	if (_element->magic != POOLMAGIC)	{					\
															\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);					\
	}

#define INIT_POOL_MAGIC(_element)							\
															\
	(_element)->magic = POOLMAGIC;


#else

#define CHECK_POOL_MAGIC(_element)

#define INIT_POOL_MAGIC(_element)

#endif


/*
 *	define the function prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern void		initializePool(POOL *, ALLOCFUNC, FOUR);
extern void		*poolDeq(POOL *);
extern void		poolEnq(POOL *, LISTELEMENT *);
extern void		poolMove(POOL *, LISTELEMENT *);

#ifdef __cplusplus
}
#endif
#endif __POOL_H__
