#ifndef _LOGACTION_H_
#define _LOGACTION_H_
/*
 *   $RCSfile: logaction.h,v $  
 *   $Revision: 2.24 $  
 *   $Date: 1993/01/28 19:56:40 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	define the types for log actions
 */
#define LOG_ACTION_NO_ACTION			0	/* none */
#define LOG_ACTION_FILE_CREATE_DONE		1
#define LOG_ACTION_LOGICAL_FILE_DESTROY	2
#define LOG_ACTION_FILE_INSERT			3
#define LOG_ACTION_FILE_DELETE			4
#define LOG_ACTION_SEQ_FILE_CREATE		5
#define LOG_ACTION_SEQ_APPEND			6
#define LOG_ACTION_SET_ROOTENTRY		7
#define LOG_ACTION_REMOVE_ROOTENTRY		8
#define LOG_ACTION_ALLOCATE_PAGE		9
#define LOG_ACTION_DEALLOCATE_PAGE		10	
#define LOG_ACTION_FILE_ROOT_FORMAT		11
#define LOG_ACTION_MARK_FILE_PAGE		12
#define LOG_ACTION_UNMARK_FILE_PAGE		13
#define LOG_ACTION_MARK_SLOTTED_PAGE	14
#define LOG_ACTION_UNMARK_SLOTTED_PAGE	15
#define LOG_ACTION_INSERT_FILE_KEY		16
#define LOG_ACTION_INSERT_FILE_KEY_DONE	17
#define LOG_ACTION_SLOTTED_PAGE_FORMAT	18
#define LOG_ACTION_INCREMENT_UNIQUE		19
#define LOG_ACTION_DELETE_FILE_KEY		20
#define LOG_ACTION_SPLIT_FILE_NODE		21

#define LOG_ACTION_LARGE_OBJ_ON_PAGE	22
#define LOG_ACTION_NO_LARGE_OBJ_ON_PAGE	23
#define LOG_ACTION_UNSET_ROOTENTRY		24

#define LOG_ACTION_WRITE_SMALL_OBJ		25
#define LOG_ACTION_CREATE_SMALL_OBJ		26
#define LOG_ACTION_DESTROY_SMALL_OBJ	27
#define LOG_ACTION_INSERT_SMALL_OBJ		28
#define LOG_ACTION_APPEND_SMALL_OBJ		29
#define LOG_ACTION_DELETE_SMALL_OBJ		30
#define LOG_ACTION_FORWARD_SMALL_OBJ	31
#define LOG_ACTION_CHANGE_SMALL_OBJHDR	32

#define LOG_ACTION_TRANS_DIRTY_PAGES	33
#define LOG_ACTION_FILE_ADD_SLOTTED     34
#define LOG_ACTION_FILE_REMOVE_SLOTTED	35

#define LOG_ACTION_LG_NODE_PAGE_FORMAT	36
#define LOG_ACTION_LG_DATA_PAGE_FORMAT	37


#define LOG_ACTION_BTREE_PAGE_FORMAT	50
#define LOG_ACTION_BTREE_PAGE_INIT		51
#define LOG_ACTION_BTREE_MODIFY_LINK	52
#define LOG_ACTION_BTREE_MODIFY_VECTOR0 53
#define LOG_ACTION_BTREE_PHYSIC_INSERT	54
#define LOG_ACTION_BTREE_PHYSIC_DELETE	55
#define LOG_ACTION_BTREE_LOGIC_INSERT	56
#define LOG_ACTION_BTREE_LOGIC_DELETE	57
#define LOG_ACTION_BTREE_MODIFY_LEVEL	58
#define LOG_ACTION_PURE_CLR				59

#define LOG_ACTION_INIT_LARGE_NODE         	65
#define LOG_ACTION_APPEND_LARGE_SLOTS		66
#define LOG_ACTION_REMOVE_LARGE_SLOTS		67
#define LOG_ACTION_WRITE_LARGE_SLOTS		68
#define LOG_ACTION_APPEND_LARGE_DATA		69
#define LOG_ACTION_REMOVE_LARGE_DATA		70	
#define LOG_ACTION_WRITE_LARGE_DATA			71	
#define LOG_ACTION_INSERT_LARGE_DATA		72	
#define LOG_ACTION_DELETE_LARGE_DATA		73
#define LOG_ACTION_CONVERT_TO_LARGEROOT		74	
#define LOG_ACTION_CONVERT_TO_LARGEHDR		75	
#define LOG_ACTION_UNDO_CONVERT_TO_LARGEROOT    76
#define LOG_ACTION_UNDO_CONVERT_TO_LARGEHDR     77
#define LOG_ACTION_INCREMENT_SLOT_BYTECOUNTS		78
#define LOG_ACTION_DECREMENT_SLOT_BYTECOUNTS		79
#define LOG_ACTION_INSERT_LARGE_SLOTS       80
#define LOG_ACTION_DELETE_LARGE_SLOTS       81
#define LOG_ACTION_WRITE_LARGE_NODE         82	
#define LOG_ACTION_CONVERT_TO_SMALL			83	

#define LOG_ACTION_BTREE_LOGIC_SET_OVERFLOW		101
#define LOG_ACTION_BTREE_LOGIC_RESET_OVERFLOW	102
#define LOG_ACTION_BTREE_LOGIC_INCR_OIDCNT		103
#define LOG_ACTION_BTREE_LOGIC_DECR_OIDCNT		104

#define LOG_ACTION_BTOV_PAGE_FORMAT				110
#define LOG_ACTION_BTOV_PAGE_INIT				111
#define LOG_ACTION_BTOV_MODIFY_NEXT_LINK		112
#define LOG_ACTION_BTOV_MODIFY_PREV_LINK		113
#define LOG_ACTION_BTOV_INSERT					114
#define LOG_ACTION_BTOV_DELETE					115

#define LOG_ACTION_NDXDESC_PAGE_FORMAT			120
#define LOG_ACTION_CREATE_INDEX					121

#define LOG_ACTION_CKPNT_DIRTY_PAGES			130	

#define LOG_ACTION_DISTR_COORD_COMMIT			131
#define LOG_ACTION_DISTR_SERVER_COMMIT			132
#define LOG_ACTION_DISTR_COORD_PREPARE_SERVERS	133
#define LOG_ACTION_DISTR_SERVER_PREPARE_VOL_LOCK 134
#define LOG_ACTION_DISTR_SERVER_PREPARE_LOCK	135
#define LOG_ACTION_DISTR_SERVER_PREPARE_VOL		136
#define LOG_ACTION_DISTR_SERVER_PREPARE_HDR		137
#define LOG_ACTION_DISTR_COORD_COMMIT_READONLY	138
#define LOG_ACTION_DISTR_COORD_PREPARE_HDR		139
/*
 *	The actions refer to operations where no data (ND) was
 *	logged.  So, the data should be zero'd.
 */
#define LOG_ACTION_DESTROY_SMALL_OBJ_ND			140	
#define LOG_ACTION_CREATE_SMALL_OBJ_ND			141	
#define LOG_ACTION_APPEND_SMALL_OBJ_ND			142	
#define LOG_ACTION_INSERT_SMALL_OBJ_ND			143	
#define LOG_ACTION_DELETE_SMALL_OBJ_ND			144	
#define LOG_ACTION_WRITE_SMALL_OBJ_ND			145	
#define LOG_ACTION_APPEND_LARGE_DATA_ND			146
#define LOG_ACTION_WRITE_LARGE_DATA_ND			147	
#define LOG_ACTION_INSERT_LARGE_DATA_ND			148	

/*
 * for linear hashing
 */
#define LOG_ACTION_LHASH_DIRPAGE_FORMAT     	160
#define LOG_ACTION_LHASH_INDEXPAGE_FORMAT   	161
#define LOG_ACTION_LHASH_DIRPAGE_INIT       	162
#define LOG_ACTION_LHASH_INDEXPAGE_INIT     	163
#define LOG_ACTION_LHASH_PHYSIC_INSERT      	164
#define LOG_ACTION_LHASH_PHYSIC_DELETE      	165
#define LOG_ACTION_LHASH_LOGIC_INSERT       	166
#define LOG_ACTION_LHASH_LOGIC_DELETE       	167
#define LOG_ACTION_LHASH_SET_INDEX_OVERFLOW 	168
#define LOG_ACTION_LHASH_RESET_INDEX_OVERFLOW 	169
#define LOG_ACTION_LHASH_DIR_UPDATE         	170
#define LOG_ACTION_LHASH_LOGIC_INCR_OIDCNT  	171
#define LOG_ACTION_LHASH_LOGIC_DECR_OIDCNT  	172
#define LOG_ACTION_LHASH_LOGIC_SET_OVERFLOW 	173
#define LOG_ACTION_LHASH_LOGIC_RESET_OVERFLOW 	174
#define LOG_ACTION_LHASH_DIR_SET_NEXT_ENTRY 	175
#define LOG_ACTION_LHASH_DIR_SPLIT_COPY 		176
#define LOG_ACTION_LHASH_DIR_SPLIT_RESET 		177
#define LOG_ACTION_LHASH_DIR_LOAD_UPDATE 		178
#define LOG_ACTION_LHASH_PHYLOG_INSERT      	179
#define LOG_ACTION_LHASH_PHYLOG_DELETE      	180
#define LOG_ACTION_LHASH_OV_CONVERT         	181
#define LOG_ACTION_LHASH_DIR_ROOT_CTRL          182
#define LOG_ACTION_LHASH_SET_THRESHOLD          183

/*
 *	Log records for entire pages
 *
 *	NOTE: These are assumed to only be generated by the
 *		  server.  If they are also generated by clients,
 *		  then they should be analyzed by analyzeCommonClientRecord
 *		  instead of analyzeCommonServerRecord.
 */
#define LOG_ACTION_ENTIRE_SLOTTED         		190
#define LOG_ACTION_ENTIRE_LARGE_NODE       		191
#define LOG_ACTION_ENTIRE_LARGE_DATA       		192
#define LOG_ACTION_ENTIRE_BTREE_PAGE       		193
#define LOG_ACTION_ENTIRE_INDEXDESC       		194

#endif /* _LOGACTION_H_ */
