#ifndef __LOCK_H__
#define __LOCK_H__
/*
 *   $RCSfile: lock.h,v $  
 *   $Revision: 2.8 $  
 *   $Date: 1992/11/19 05:56:35 $      
 */ 

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/* BEGIN visible to user */

/*
 *	the typedef for a lock mode.  The size of this
 *	definition defines the number of lock modes that
 *	can be allocated
 */
typedef UONE	LOCKMODE;


/*
 *	define the specific information that relates to our type of lock modes
 */
#define NUM_LOCK_MODES		6

/* END visible to user */

/*
 *	define the maximum and minimum lock mode
 */
#define MIN_LOCK_MODE		1
#define MAX_LOCK_MODE		(NUM_LOCK_MODES - 1)


/*
 *	typedef for lock class
 */
typedef UONE	LOCKCLASS;


/*
 *	define the maximum number of lock classes that can exist
 */
#define NUM_LOCK_CLASSES	32
#define MAX_LOCK_CLASS		31
#define MIN_LOCK_CLASS		 0	
typedef UFOUR	CLASSMAP;


/*
 *	definition of the default and runtime lock classes
 */
#define RUNTIME_LOCK_CLASS	-1
#define DEFAULT_LOCK_CLASS	0

/* BEGIN visible to user */

/*
 *	define the lock modes
 */
#define NL	0
#define IS	1
#define IX	2
#define SH	3
#define SIX	4
#define EX	5

/* END visible to user */

/*
 *	define the types of locks
 */
#define LOCK_NOWAIT		0x1
#define LOCK_INSTANT	0x2


/*
 *	define a macro for printing a lock mode
 */
#define GETMODE(_lockMode)				\
										\
	LM_Character[(_lockMode)]
/*
 *  macro for deciding if a lock is a write lock
 */
#define WRITE_LOCK(_lockEntry)                  \
                                                \
    (_lockEntry->lockHeader->supremum == EX)


/*
 *	define a macro for deciding if a lock should be logged
 *	with the prepare log record
 */
#define PREPARELOG(_lockEntry)					\
												\
	((_lockEntry->lockHeader->supremum == IX)	\
	||(_lockEntry->lockHeader->supremum == SIX)	\
	||(_lockEntry->lockHeader->supremum == EX))	

/* (lockEntry->lockHeader->hashList.lockid.file.type != PAGE_LOCK) */

/*
 *	define the types of locks
 */
#define PAGE_LOCK		1
#define FILE_LOCK		2
#define ROOT_SLOT_LOCK	3

#endif __LOCK_H__
