#ifndef _GLOBAL_TRACE_H_
#define _GLOBAL_TRACE_H_
/*
 *   $RCSfile: global_trace.h,v $  
 *   $Revision: 2.13 $  
 *   $Date: 1993/02/01 17:14:35 $      
 */ 
#ifndef __TRACE_H__
#define __TRACE_H__


/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
/* BEGIN visible to user */

/*
 *	Definition of tracing areas
 */
#define TR_DEBUG		0x1
#define TR_BF			0x2
#define TR_LIST			0x4
#define TR_FI			0x8

#define TR_SM			0x10
#define TR_LG			0x20
#define TR_EH			0x40
#define TR_IO			0x80

#define TR_TEST			0x100
#define TR_THREAD		0x200
#define TR_LATCH		0x400
#define TR_SEM			0x800

#define TR_INIT			0x1000
#define TR_DISK			0x2000
#define TR_MSG			0x4000
#define TR_DISKRW		0x8000

#define TR_ADMIN		0x10000
#define TR_CL			0x20000
#define TR_BITMAP		0x40000
#define TR_TRANS		0x80000

#define TR_LOCK			0x100000
#define TR_LOG			0x200000
#define TR_RECOVER		0x400000
#define TR_ACCESS		0x800000

#define TR_SEQ			0x1000000
#define TR_VERSION		0x2000000
#define TR_VHGLIST		0x4000000 /* version history graph list funcs */
#define TR_SHM			0x8000000 /* shared memory functions		 */

#define TR_DISTR		0x10000000	/* for distr trans */
#define TR_MR			0x20000000	/* media recovery */


/*
 *	definition of trace flags
 */
typedef unsigned long TRACEFLAGS;


/*
 *	define a trace array for levels
 */
typedef struct	{

	unsigned char	level[32];

} TRACELEVEL;


/*
 *	put in the extern declaration
 */
extern TRACEFLAGS	TraceFlags;
extern char			*TraceName;
extern TRACELEVEL	TraceLevel;


/*
 *	define the tracing levels
 */
#define TR_LEVEL_0		(0)
#define TR_LEVEL_1		(1)
#define TR_LEVEL_2		(2)
#define TR_LEVEL_3		(3)


/*
 *	define function prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern int	checkTraceLevel PROTO((TRACEFLAGS, int));

#ifdef __cplusplus
}
#endif

/* END visible to user */
#endif __TRACE_H__
#endif /* _GLOBAL_TRACE_H_ */
