#ifndef _CLASS_ALIAS_MACROS_H_
#define _CLASS_ALIAS_MACROS_H_
#ifndef __class_alias_macros_h__
#define __class_alias_macros_h__
/*
 *   $RCSfile: class_alias_macros.h,v $  
 *   $Revision: 1.3 $  
 *   $Date: 1993/04/21 17:21:05 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/* 
 * Grotesque macros for C wrappers for C++ functions.
 * here for hysterical purposes; The real solution is 
 * to remove the C wrappers and turn all the
 * affected structs into classes, now that we compile 
 * the whole SM with C++.
 */
#ifdef _CAT
#undef _CAT
#endif

#if defined(__STRICT_ANSI__) || defined(__GNUC__)
#	define _CAT(_a,_b) _a##_b
#endif

#ifndef _CAT
#define _CAT(_a,_b) _a/**/_b
#endif

#define CLASS_ALIAS(_x) 		_CAT(_x,c)
#define CLASS_TYPE(_typ) 		_CAT(_typ,CLASS)

#define NONCLASS_ALIAS(_x) &(_x->p)

#endif __class_alias_macros_h__
#endif /* _CLASS_ALIAS_MACROS_H_ */
