#ifndef _CC_MACRO_H_
#define _CC_MACRO_H_
/*
 *   $RCSfile: cc_macro.h,v $  
 *   $Revision: 1.5 $  
 *   $Date: 1992/11/27 16:45:55 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifdef __cplusplus

inline int operator==(const OID& o1, const OID& o2)
{
    return o1.diskAddr.unique == o2.diskAddr.unique &&
           o1.diskAddr.slot == o2.diskAddr.slot &&
           o1.diskAddr.page == o2.diskAddr.page &&
           o1.diskAddr.volid == o2.diskAddr.volid;
}


inline int operator!=(const OID& o1, const OID& o2)
{
    return ! (o1 == o2);
}


inline int operator==(const PID& p1, const PID& p2)
{
	return p1.page == p2.page && p1.volid == p2.volid;
}



inline int operator!=(const PID& p1, const PID& p2)
{
	return !(p1 == p2);
}

#endif
#endif /* _CC_MACRO_H_ */
