#ifndef __VOLREC_H__
#define __VOLREC_H__
/*
 *   $RCSfile: VOLREC.h,v $  
 *   $Revision: 1.1 $  
 *   $Date: 1993/04/21 17:20:59 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#include "VOLIDCLASS.h"


void 
VOLREC:: Dump(FILE *f) {
	fprintf(f,  "DUMP OF VOLREC 0x%x\n", this);
#ifdef SERVER_MAKE
	fprintf(f, "volflags 0x%x, volid %d volName %s\n",
		this->volflags, this->volid, 
		(this->volNameRec==NULL) ? "NONE" : this->volNameRec->volName.name);
#else SERVER_MAKE
	fprintf(f, "flags 0x%x, volid %d volName %s\n",
		this->flags, this->volid, this->volName);
	fprintf(f,  "serverInfo 0x%x\n", this->serverInfo);
#endif SERVER_MAKE

}; 

VOLIDCLASS *
VOLREC:: keylocation (int unique, VOLIDCLASS **unused) {
	SM_ASSERT(LEVEL_1, (unique != 0));
	return (VOLIDCLASS *)&(this->volid);
};

LISTELEMENT *
VOLREC:: listlocation (int unique) {
	SM_ASSERT(LEVEL_1, (unique == VOLREC_POOL)  || (unique == VOLREC_TABLE) );
	return &(hashList); 
};

void 
VOLREC:: ReInit() {
#ifdef SERVER_MAKE
	this->header = NULL;
	this->volflags = VOL_FREE;
	this->volLink = NULL; /* it's not malloced; it's a ptr to
		a static structure so it's ok just to blow it away */
	this->fd = 0;
	this->diskrwPid = 0;
	SM_ASSERT(LEVEL_1, (LIST_EMPTY(&(this->activeTransList))) );
	SM_ASSERT(LEVEL_1, (LIST_EMPTY(&(this->tcbList))) );
	SM_ASSERT(LEVEL_1, (LIST_EMPTY(&(this->activeTransList))) );
#else
	this->flags = VOL_FREE;
	this->serverInfo = NULL;
	this->volid = 0;
	bzero(this->volName, DEVNAMEMAX);
#endif SERVER_MAKE
};

void 
VOLREC:: Init() {
	bzero((char *)this, sizeof(VOLREC));
	initializeListElement(this->listlocation(VOLREC_POOL), this);
#ifdef SERVER_MAKE
	/* this->queue is initialized with a ForEach pass through the pool */
	initializeLatch( &(this->latch) );
	initializeList(&(this->openList));
	initializeList(&(this->tcbList));
	initializeList(&(this->activeTransList));
#endif SERVER_MAKE
	this->ReInit();
};

#endif __VOLREC_H__
