#ifndef __VOLIDCLASS_H_
#define __VOLIDCLASS_H_
/*
 *   $RCSfile: VOLIDCLASS.h,v $  
 *   $Revision: 1.2 $  
 *   $Date: 1993/04/21 17:20:53 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *****************************************************************
 *       c-callable wrapper for PIDs for use with hash tables
 *****************************************************************
 */

#include "resources.h"
#include "ess.h"
#include "io.h"
#include "volume.h"

class VOLIDCLASS {
public:
	VOLID p;

	BOOL equalFunc(VOLIDCLASS *other) const {
		return other->p == this->p;
	};
	int hashFunc() const { return (int)(this->p); };

	void Dump(FILE *f) {
		fprintf(f,  "DUMP OF VOLID 0x%x\n", this->p);
	}; 
	void ReInit() {
		this->p = NULLVOLID;
	};
	void Init() {
		this->ReInit();
	};
}; /* VOLIDCLASS */

#endif __VOLIDCLASS_H_
