#ifndef _LH_HASH_H_
#define _LH_HASH_H_
/*
 *	$RCSfile: LH_Hash.h,v $
 *	$Revision: 1.5 $
 *	$Date: 1992/11/27 16:45:41 $
 */
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#ifndef	_LH_Hash_H_
#define _LH_Hash_H_
/* LH_Hash.h */



#ifdef __cplusplus

const INIT_PRIMARY = 7;

const NUMBUCKETS = INIT_PRIMARY;      //  initial number of primary buckets

const float CONVERT_FACTOR = 10000.0; //  constant by which to multiply 
				      //  floats and doubles
const MAXHASHLEVEL = 31; 

const HASH_MAGIC = 211;

#endif

int LH_Hash(TWO keylen, const void *keyval,SMDATATYPE keytype,TWO level);

#endif
#endif /* _LH_HASH_H_ */
