#ifndef _BT_LOG_H_
#define _BT_LOG_H_
/*
 *   $RCSfile: BT_Log.h,v $  
 *   $Revision: 1.9 $  
 *   $Date: 1993/04/19 21:47:14 $      
 */ 
#ifndef __BT_LOG_H__
#define __BT_LOG_H__


struct LogBtreePageInitData {
		TWO			newLevel;
		SMDATATYPE	keyType;
		
		int Size()	{ return sizeof(*this); }
		};

struct LogBtreeModifyLinkData {
		SHORTPID 	oldNext;
		SHORTPID	newNext;
		SHORTPID	oldPrev;
		SHORTPID	newPrev;
		
		int Size()	{ return sizeof(*this); }
		};
		
struct LogBtreeModifyVector0Data {
		SHORTPID	oldPid0;
		SHORTPID	newPid0;
		
		int Size()	{ return sizeof(*this); }
		};
		
struct LogBtreeModifyLevelData {
		TWO			oldLevel;
		TWO			newLevel;
		
		int Size()	{ return sizeof(*this); }
		};

// #define BTOFFSET(rec, field)	(((char*) &(rec->field)) - (char*) rec)

struct LogBtreePhysicInsertData {
		TWO			startSlot;
		TWO			numSlots;
		FOUR		length;
		char		data[1];
		
		int Size()	{ return data + length - (char*) this; }
		int Max()	{ return BTREE_PAGESIZE - (data - (char*) this) - ALIGNSIZE(sizeof(LOGRECORDHDR)) - (2*ALIGNSIZE(sizeof(LOGPAGEHDR))); }
		};

typedef LogBtreePhysicInsertData LogBtreePhysicDeleteData;
		
		
struct LogBtreeLogicInsertData {
		PID			rootPid;
		TWO			elSize;
		TWO			maxKeyLen;
		TWO			unique;
		TWO			keyLen;
		SMDATATYPE	keyType;
		char		data[1];
		
		int Size()	{ return data + ALIGNSIZE(keyLen) + elSize 
														- (char*) this; }
		void* Key() { return data; }
		void* El()	{ return data + ALIGNSIZE(keyLen); }
		};

typedef LogBtreeLogicInsertData LogBtreeLogicDeleteData;

struct LogBtreeLogicIncrElCntData {
		PID			rootPid;
		TWO			maxKeyLen;
		TWO			keyLen;
		SMDATATYPE	keyType;
		char		key[1];
		
		int Size()	{ return key + keyLen - (char*) this; }		
		};
		
typedef LogBtreeLogicIncrElCntData LogBtreeLogicDecrElCntData;

struct LogBtreeLogicSetOverflowData {
		PID			rootPid;
		PID			ovPid;
		TWO			maxKeyLen;
		TWO			keyLen;
		TWO			numEl;
		TWO			elSize;
		SMDATATYPE	keyType;
		char		data[1];
		
		int Size()	{ return data + keyLen + 
								numEl*elSize - (char*)this; }
		char* 	KeyValue()	{ return data; }
		char* 	ElList()	{ return data + keyLen; }
		};

typedef LogBtreeLogicSetOverflowData LogBtreeLogicResetOverflowData;


struct LogBtOvPageInitData {
		TWO			elSize;
		
		int Size()	{ return sizeof(*this); }
		};		

struct LogBtOvModifyNextLink {
		PID			rootPid;
		SHORTPID	oldNext;
		SHORTPID	newNext;
		
		int Size()	{ return sizeof(*this); }
		};

struct LogBtOvModifyPrevLink {
		PID			rootPid;
		SHORTPID	oldPrev;
		SHORTPID	newPrev;
		
		int Size()	{ return sizeof(*this); }
		};


struct LogBtOvInsert {
		PID			rootPid;
		TWO			startSlot;
		TWO			numSlots;
		TWO			elSize;
		char		data[1];
		
		int Size()	{ return (data + elSize * numSlots) - (char*) this; }
		int Max()	{ return BTREE_PAGESIZE - 
								(data - (char*) this) - 100; }
		};

typedef LogBtOvInsert LogBtOvDelete;

		

#endif /* __BT_LOG_H__ */
#endif /* _BT_LOG_H_ */
