.TH Makefile 1 
.SH NAME
Makefile \- making an Exodus Storage Manager
.SH DESCRIPTION
.PP
This manual page describes the content and use of the storage manager
makefiles.
The storage manager source spans many directories.
Each directory contains a
.BR Makefile .
There is a single
.BR makefile.common ,
which is included by each 
.BR Makefile .
Other makefiles included by every 
.BR Makefile are 
.BR makefile.install ,
.BR makefile.options , 
and
.BR makefile.tags .
Superdirectories may contain a
.BR makefile.subdir ,
which each 
.IB subdir/ Makefile
includes.
.SH "MAKE OPTIONS"
.IP "Silent Makes:" 15
You have several ways to limit the output of the makes.
You can use the -s option, to prevent Make from printing each
command it executes.
(See make(1).)
.IP
You can set your environment variable LOCK to "-q"
and use the "-e" option with Make, to make the rcs functions like
co and ci quiet.
(See co(1), ci(1), rcs(1).)
.IP
You can comment out the .DEFAULT rule in 
.BR workspace/makefile.common ,
to prevent the printing of 
"Making 
.IR target in 
.BR directory .
" for each target made.
.IP "Partial Makes:" 15
You can work on a portion of the storage manager code without
having to make the entire storage manager, or having to 
copy the source for the entire storage manager.
This is useful when you are working on a workstation
that has little available disk space, and want to mount most
of the source from another machine.
It is also useful when several people are working on the code at once.
A stable "baseline" copy is kept on a server machine.
Each programmer has his own "workspace".
The Makefiles have macros that specify which modules of the
storage manager are in you workspace, and which are taken from the
baseline.
Modules taken from the baseline are taken in object or executable form.
Thing in your workspace are made from a copy of the source.
See MOD_WORKSPACE and MOD_BASELINE, under "MACROS", below.
.SH "CONFIGURATION OPTIONS"
.IP "Debugging:" 15
The storage manager can be made with several debugging options,
which can be combined.
.IP
If the DEBUG C preprocessor flag is defined (with -DDEBUG),
the storage manager includes myriad internal checks.
Some of the checks are CPU-intensive.
.IP
The -g compiler flag can be used to generate symbols 
for use with dbx(1). (See cc(1), dbx(1).)
.IP "Optimization:" 15
The -O compiler flag can be used, in the absence of -g,
to generate optimized code.
-O cannot be used with -g; -g3 is used with -g to create
optimized code with symbols.
.IP "Profiling:" 15
The storage manager can be configured to profile itself by using
compiler flags
-DPROFIL -p.
(See prof(1).)
When compiled with -DPROFIL,
the storage manager responds to the cl_MonDump() client request
by writing its profiling information to a file, and passing along
the request to all its disk processes, who do the same.
Use the environment variable PROFDIR, so that each process writes its 
profiling information in a different file.
.IP "IPC configuration options:" 15
The server and disk processes communicate in one of two ways:
with Unix-domain sockets (see socket(2)), or with
shared-memory queues.
When the storage manager is made with -DDISK_QUEUES, the 
queues are used. When DISK_QUEUES is not defined, the
processes use Unix-domain sockets.
.SH MACROS
These three macros are defined in 
.BR makefile.install :
.IP "BINDIR" 20
The directory where executables are installed.
.IP "INCLUDEDIR" 20
The directory where include files are installed.
.IP "LIBDIR" 20
The directory where libraries are installed.
.LP
The following targets are defined in 
.BR makefile.options .
If you want to make a server with a different configuration
from the default, you edit 
.BR makefile.options ,
which contains comments describing each of the targets.
All executables must be made with the same options, since
the executables represent processes that communicate and the
processes must agree on both their style and content of communication, 
which are controlled by these flags.
A suffix can be attached to the executable names so that 
different versions of the executables can be made and installed.
.IP "DEBUGFLAGS " 20
This macro takes the combined debugging, profiling, and optimization
configuration options (listed in 
.BR "CONFIGURATION OPTIONS" , 
above.
.IP "DISKPROCNAME" 20
The name of the disk process to be exec-ed after the server forks.
.IP "DISKRW" 20
The name of the disk process to be exec-ed after the server forks.
.IP "FORMATVOL" 20
The name of the formatvol program.
.IP "SERVER" 20
The name of the server program.
.IP "SUFFIX" 20
The suffix attached to each of formatvol, diskrw, and sm_server to make
FORMATVOL, DISKRW, SERVER, respectively.
.IP "QUEUES" 20
Is either -DDISK_QUEUES or null.
If -DDISK_QUEUES, shared memory queues will be used for communication
between the server and its subordinate processes (diskrw).
If null, Unix-domain sockets are used.
.LP
Each Makefile (or the environment) must define each of these 
macros.
Null values are acceptable for most; those that cannot be null
are marked with "!".
Those marked with "*" are defined in 
.BR makefile.subdir.common ;
those marked with "+" are define in 
.BR makefile.subdirs .

.IP "+EXECS" 20
The executables produced in this directory.
.IP "FILESC " 20
The C or C++ source files in this directory.
.IP "FILESH	" 20
The header files in this directory.
.IP "FILESO " 20
The object files created in this directory.
.IP "+LITTLEMAKEFILE" 20
When non-null, "make workspace" treats this directory
as a super-directory (rather than a leaf directory),
one in which you might choose to take parts from the baseline and
parts from the workspace.
See the target
.IR workspace.1level ,
below.
.IP "LOCALCLEANFILES" 20
The target
.IR clean:
removes garbage files that are common to all directories,
and those listed in common macros,
such as $(FILESO), $(EXECS), makefile.depend, makefile.depend.bak,
tags*, and so on.
Any garbage files that are local to a directory will be removed
if they are listed in this macro.
.IP "LOCALRCSFILES " 20
Files that are to be checked in and out with RCS,
other than FILESH, FILESC, and MAKEFILES.
.IP "+LOCAL_FLAGS" 20
For server modules this must include -DSERVER_MAKE to distinguish
the client and server versions of 
object files that are created from common sources. 
For disk-process files, LOCAL_FLAGS must also include -DDISKPROC_MAKE,
to distinguish  server and disk-process versions of 
object files that are created from common sources. 
.IP "LOCK" 20
The RCS locks used for checking sources in and out.
.IP "!+MAKEFILES" 20
A list of the makefiles in this directory.
All directories use 
.BR Makefile .
Some directories also contain
.BR makefile.subdir .
.IP "!MODULE " 20
The name of this directory (without its path).
.IP "+MOD_BASELINE " 20
A list of the immediate subdirectories that will come from the baseline.
.IP "+MOD_WORKSPACE " 20
A list of the immediate subdirectories that are in the workspace.
.IP "OTHERTAGS" 20
Tags files that should be incorporated with tags in this directory.
Tags depends on $(OTHERTAGS) so be careful not to create circular references.
.IP "!+PARENT " 20
The name of 
.BR ..
without its path.
.IP "!+PATHTOROOT" 20
The path from this dirctory to the root of the workspace.
For example, in
.BR workspace/client/bf ,
PATHTOROOT is "../..".
.IP "+SPECIALINCLUDE" 20
Any include directory other than 
.BF workspace/include
and 
.BF workspace/common/include
that's needed in this directory.
.SH TARGETS
.LP
These targets are available at all levels.  
.IP "ci:" 20
Checks in everything listed in MAKEFILES, FILESC, FILESH, and
LOCALRCSFILES.
Checks in MAKEFILES with -u $(LOCK), and the rest with $(LOCK).
Recursive.
.IP "clean:" 20
Cleans out everything but the MAKEFILES and sources.
Removes object files, executables (EXEC) and LOCALCLEANFILES.
Recursive.
.IP "co:" 20
Checks out everything listed in MAKEFILES, FILESC, FILESH, and
LOCALRCSFILES.
Checks out with $(LOCK).
Recursive.
.IP "copies:" 20
Copies files listed in COPIES into 
the working directory (.).
If the source file does not exist, the error is ignored.
.IP "default:" 20
Alias for workspace.mod; appears at the beginning.
Recursive.
.IP "depend:" 20
Makes dependencies for everything listed in FILESC.
Recursive.
.IP "dummy*:" 20
Fake targets that are necessary only to keep the makefile syntax
error-free when certain macros are undefined.
.IP "getbaselineparts:" 20
Gets the products of the submodules listed in 
MOD_BASELINE (rather than the product of ".") from the baseline.
Used when parts of the module are from the baseline and parts are in
the workspace.  
Recursive.
.IP "getmakefiles :" 20
Checks out only the MAKEFILES in each directory.  
Recursive.
.IP "install :" 20
Installs the products in the directories listed in 
.BR makefile.install .
Recursive.
.IP "links :" 20
Makes symbolic links from . to each of the files listed in LINKS.
See also target 
.IR $(LINKS) ,
below.
.IP "makefile :" 20
Makes a writable copy of Makefile, in 
.B makefile
if 
.B makefile
is out-of-date or non-existent.
.IP "makercs :" 20
Makes links named RCS to the RCS directories in $BASELINE at each level.
Recursive.
.IP "rcsdiff:" 20
Recursive.
.IP "saber_obj:" 20
Not used.
.IP "saber_src:" 20
Not used.
.IP "touch:" 20
Like "make -t", except that each directory touches its own products, whose
names differ.
Recursive.
.IP "workspace:" 20
Creates the directory structure and, for the first level (only),
gets from the baseline the modules that are listed in MOD_BASELINE,
and gets source for the (entire) modules that are in MOD_WORKSPACE.
Recursive, but keep in mind that when you first create a workspace,
the default Makefiles indicate that everything is in MOD_WORKSPACE.
If you want to get any parts from the baseline, you should use
the target 
.IR workspace.1level : 
edit the resulting 
.BR makefile s
as needed, before doing "make workspace".
.IP "workspace.1level:" 20
Creates the subdirectories of "."
and checks out the makefiles in each subdirectory.
If the macro LITTLEMAKEFILE in 
any 
.BR Makefile is 
defined and non-null, and if 
.B makefile
is not up-to-date, this rule also makes a writable copy of 
.BR Makefile 
in 
.BR makefile .
This target is meant to be used when "."
contains modules that could be taken from the baseline.
Directories that do not have parts that could be taken from
the baseline should not define LITTLEMAKEFILE in their Makefiles.
.IP "workspace.recursive:" 20
Recursive part of the target 
.IR workspace :.
.IP "workspace.mod.recursive:" 20
The recursive part of the target 
.IR workspace.mod :.
.IP "$(COPIES)" 20
Copies the target source file to ".".
If the source file does not exist, the resulting error is ignored.
See target copies.
.IP "$(FILESO)" 20
Compiles object files listed in FILESO.
.IP "$(LIBS)" 20
If the product depends on any libraries, the libraries
are listed in LIBS, with full path names.
This target goes to the directory in which the libraries
are made, and makes them there.
.IP "$(LINKS)" 20
If the target file does not exist, it makes the file in its home directory.
Makes a symbolic link from this directory to the target. 
To make the symbolic links without making the target file, use the target
.IR links :.
.IP "$(MOD_WORKSPACE) $(MOD_BASELINE)" 20
Useful when you want to add a module to the workspace (from the baseline)
or vice versa.  Remove the module's directory and its contents, and then
"make <module>".
.IP "$(RCSFILES)" 20
Compiles object files listed in FILESO,
checks out source files listed in FILESC and FILESH,
MAKEFILES, and LOCALRCSFILES.
.\" -------------------------------------------------------------
.LP
The following targets are available at the root of the workspace:
.IP "install_directories:" 20
Makes the bin/, lib/, and h/ directories named in 
.BR makefile.install .
Invoked by the target 
.IR workspace :.
.IP "tags.clean:" 20
Removes duplicate tags files in the subdirectories.
.\" -------------------------------------------------------------
.LP
The following targets are defined in each directory's Makefile:
.IP "getbaseline:" 20
Gets the module's product from the baseline.
Does not get source or intermediate results such as object files (unless
the product of the module is an object file).
.IP "workspace.mod:" 20
This is the default target.
It makes all object files and final products in each directory.
It must be define if the product of the directory is anything
other than that defined in FILESO and EXECS (such as as library).
Recursive.
.SH RESTRICTIONS
.PP
The client and server have some function names in common, such as
bf_ReadPage, so it is not possible to have a global tags file for
the entire storage manager.
Instead, there are separate tags files for
client modules and for server modules.
The tags files you use depend on your working directory.
Since not all of the source is in a workspace, you also need
to use tags from the baseline.
The unfortunate result is that all the tags in the tags files
have absolute path names.
This may create problems for people who mount a baseline with NFS.
.SH SEE ALSO
Makefile \- making an Exodus Storage Manager workspace
