// program to perform a toy debit/credit transaction

#include <stdio.h>
#include <osfcn.h>
#include <E/trans.h>
#include "data.h"

persistent extern tellerFile   tellers;
persistent extern branchFile   branches;
persistent extern accountFile  accounts;
persistent extern dbint        xtime;
persistent extern historyFile  history;
main()
{
    // user input parameters
    int anoInput;
    int tnoInput;
    int deltaInput;
    // corresponding db type values
    dbint ano;
    dbint tno;
    dbint delta;
    // pointers to affected records
    branch*  b;
    teller*  t;
    account* a;
    historyRec* h;

    // read in transaction parameters
    printf("Enter account_no, teller_no, and delta_amt: ");
    scanf("%d %d %d", &anoInput, &tnoInput, &deltaInput);
    ano   = anoInput;
    tno   = tnoInput;
    delta = deltaInput;

	
    E_BeginTransaction();
    // find relevant account record
    a = accounts.find(ano);
    if (a == NULL) {
	printf("Bad account number - aborting transaction!\n");
	exit(1);
    }

    // find relevant teller record
    t = tellers.find(tno);
    if (t == NULL) {
	printf("Bad teller number - aborting transaction!\n");
	exit(1);
    }

    // find relevant branch record
    b = branches.find(a->branchNo);
    if (b == NULL) {
	printf("Bad branch number for account - aborting transaction!\n");
	exit(1);
    }

    // update balances appropriately
    a->balance += delta;
    b->balance += delta;
    t->balance += delta;

    // add corresponding record to audit trail
    h = new (history) historyRec;
    h->time = xtime++;
    h->accountNo = ano;
    h->tellerNo = tno;
    h->delta = delta;
    h->newBalance = a->balance;
    E_CommitTransaction();

    // print transaction completion message
    printf("Transaction successfully committed!\n");

}

