

// program to print the current contents of the debit/credit database

#include <stdio.h>
#include "data.h"
#include <E/trans.h>

persistent extern tellerFile   tellers;
persistent extern branchFile   branches;
persistent extern accountFile  accounts;
persistent extern historyFile  history;


typedef tuple<teller> teller_tuple;
typedef tuple<branch> branch_tuple;
typedef tuple<account> account_tuple;
main()
{
    E_BeginTransaction();
    printf("Contents of teller file:\n");
    {
      tuple<teller> * scanpt;
      collection_scan<teller_tuple> teller_scan(tellers.nodeFile);
      while (scanpt = teller_scan.next())
      {
	teller * t = &scanpt->record;
        printf("[%d, %d]\n", t->tellerNo, t->balance);
      }
    }
    printf("Contents of branch file:\n");
    {
      tuple<branch> * scanpt;
      collection_scan<branch_tuple> branch_scan(branches.nodeFile);
      while (scanpt = branch_scan.next())
      {
	branch * t = &scanpt->record;
        printf("[%d, %d]\n", t->branchNo, t->balance);
      }
    }

    printf("Contents of account file:\n");
    {
      tuple<account> * scanpt;
      collection_scan<account_tuple> account_scan(accounts.nodeFile);
      while (scanpt = account_scan.next())
      {
	account * t = &scanpt->record;
        printf("[%d, %d, %d]\n", t->accountNo, t->branchNo, t->balance);
      }
    }

    printf("Contents of history file:\n");
    {
      collection_scan<historyRec> history_scan(history);
      historyRec * h;
      while (h = history_scan.next())
      {
        printf("[%d, %d, %d, %d]\n",
	        h->time, h->accountNo, h->delta, h->newBalance);
      }
    }
    E_CommitTransaction();

}

