
#define NULL 0
// auxiliary types
template <dbclass recType > dbstruct tuple {
public:
    recType  record;
    tuple*   next;
};

// simple hashed file class definition

template <
    dbclass keyType ,
    dbclass recType ,
    const int hashTableSize
>
dbclass hashFile 
{


    // data members
public:
private:

    tuple<recType> *     hashTable[hashTableSize];

    // this were parameters in cfront e version 
    int compare(keyType&, recType&);
    int hash(keyType&);
public:
// collection really shouldn't be public but this makes the scan easier 
    collection<tuple<recType> >  nodeFile;
    hashFile()
    {
	int     hashIndex;

	for (hashIndex = 0; hashIndex < hashTableSize; hashIndex++) {
	    hashTable[hashIndex] = 0;
	}
   };

    void append(keyType& key, recType& rec)
    {
	int     hashIndex;
	tuple<recType> *  newRec;

	hashIndex = hash(key);
	newRec = new (nodeFile) tuple<recType> ;
	newRec->record = rec;
	newRec->next = hashTable[hashIndex];
	hashTable[hashIndex] = newRec;
    };
    recType* find(keyType& key)
    {
	int     hashIndex;
	tuple<recType> *  curNode;

	hashIndex = hash(key);
	curNode = hashTable[hashIndex];
	while (curNode != NULL && compare(key, curNode->record) != 0) {
	    curNode = curNode->next;
	}

	if (curNode == NULL) {
	    return NULL;
	} else {
	    return &(curNode->record);
	}
    };
    // iterator recType*	scan();
};







