#ifndef _sm_index_h
#define _sm_index_h 1
#include <stdio.h>
#include <E/trans.h>
#include <E/sm_client.h>
extern VOLID __Evolid;
extern int __Ebg;

template <class keytype, class valtype> dbclass index
{

	union elem_un {   valtype this_val; char space[sizeof(valtype )];};
  public:
	IID index_id;
	int errno;
	index(SMTYPE itype,BOOL uniqf=0);
	~index() { IID this_index_index; int rc;
	   this_index_index = index_id; 
	   rc = sm_DestroyIndex(&this_index_index,__Ebg);
	};
	insert(keytype key,valtype elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.this_val = elt;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(keytype key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.this_val = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class vindex_retrieve_base // base class for various scan classes
{
protected:
  IID index_id;
  SMCURSOR cursor;
  KEY  cur_key;
  KEY  lower_key;
  KEY  upper_key;
  // a bunch of flags
  char lower_excl, upper_excl; // are lower/upper bounds inclusive or exclusive?
  char lower_set, upper_set;   // have bounds been set?
  char retrieve_started; 		// has scan been started?
  char reverse;
  char *elem_pt; // pointer to current element; set in template ctor..
  index_retrieve_base() 
  { lower_excl = 0; upper_excl = 0; 
    lower_set = 0; upper_set = 0; 
    retrieve_started = 0; eof = 1; 
    reverse = 0; errno = 0; 
  };
  void fetch_init();
  void init_scan();
public:
  BOOL eof; 			// has end been reached?
  int errno;
  // union {
    // dbvoid * cur_elem; // 
    // char dbpt_space[sizeof(dbvoid *)];
  // };
  void next(); // advance cursor; set next element.
};
 
template <class keytype,class valtype> class index_retrieve: public vindex_retrieve_base
{
	keytype lower_keyval;
	keytype upper_keyval;
public:
	keytype cur_keyval;
	// anonymous union containing space for value
	union {
		valtype cur_value;
		char val_space[sizeof(valtype)];
	};
	// cur_elem pointer inherited from index_retrieve_base
	void retrieve_init()
	{
	  lower_key.valuePtr = &lower_keyval;
	  lower_key.length = sizeof(lower_keyval);
	  upper_key.valuePtr = &upper_keyval;
	  upper_key.length = sizeof(upper_keyval);
	  cur_key.valuePtr = &cur_keyval;
	  cur_key.length = sizeof(cur_keyval);
	  elem_pt = &val_space[0];
	};
	// single point retrieve
	index_retrieve(index<keytype,valtype>& this_index,keytype test)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetLB(test);
	  SetUB(test);
	};
	index_retrieve(index<keytype> &this_index)   // no key; set later.
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	};

	index_retrieve(index<keytype>& this_index,keytype lb, keytype up, int exl=0)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetLB(lb,exl);
	  SetUB(up,exl);
	};
	void SetLB(keytype tval, int exclusive=0) 
	{ lower_keyval= tval; lower_excl = exclusive; lower_set =1; };
	void SetUB(keytype tval, int exclusive=0) 
	{ upper_keyval= tval; upper_excl = exclusive; upper_set =1; };
};

dbclass str_index
{

  public:
	IID index_id;
	int errno;
	int max_len;
	str_index(SMTYPE itype,int maxkey, BOOL uniqf=0);
	~str_index() { IID this_index_index; int rc;
	   this_index_index = index_id; 
	   rc = sm_DestroyIndex(&this_index_index,__Ebg);
	};
	insert(char * key,dbvoid * elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.dbpt = elt;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(char * key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.dbpt = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class str_index_retrieve: public index_retrieve_base
{
	char * lower_keyval;
	char * upper_keyval;
	int max_len;
public:
	char * cur_keyval;
	// single point retrieve
	str_index_retrieve(str_index& this_index,char * test)
	{
	  index_id = this_index.index_id;
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_index.max_len;
	  max_len = this_index.max_len;
	  SetLB(test);
	  SetUB(test);
	};
	str_index_retrieve(str_index& this_index,char * lb, char *ub,int excl=0)
	{
	  index_id = this_index.index_id;
	  // unfortunately we seem to need to allocate string space.
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_index.max_len;
	  max_len = this_index.max_len;
	  SetLB(lb,excl);
	  SetUB(ub,excl);
	};
	str_index_retrieve(str_index &this_index)   // no key; set later.
	{
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_key.length = this_index.max_len;
	  cur_keyval = (char *)cur_key.valuePtr;
	  max_len = this_index.max_len;
	  index_id = this_index.index_id;
	};
	~str_index_retrieve()
	{
		delete cur_keyval;
	}
	void
	next() { cur_key.length = max_len; index_retrieve_base::next();}

	void SetLB(char * tval, int exclusive=0) 
	{ lower_key.valuePtr = tval; lower_key.length = strlen(tval)+1;
	  lower_excl = exclusive; lower_set =1; };
	void SetUB(char * tval, int exclusive=0) 
	{ upper_key.valuePtr = tval; upper_key.length = strlen(tval)+1;
	  upper_excl = exclusive; upper_set =1; };
};
#endif
