#ifndef _sm_index_h
#define _sm_index_h 1
#include <stdio.h>
#include <E/trans.h>
#include <E/sm_client.h>
extern VOLID __Evolid;
extern int __Ebg;

union elem_un { dbvoid * dbpt; char space[sizeof(dbvoid *)];};
template <class t> dbclass sm_index
{
  public:
	IID index_id;
	int errno;
	sm_index(SMTYPE itype= SM_BTREENDX,BOOL uniqf=0);
	~sm_index() { IID this_index_index; int rc;
	    this_index_index = index_id; 
	    rc = sm_DestroyIndex(&this_index_index,__Ebg);
	 };
	insert(t key,dbvoid * elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.dbpt = elt;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(t key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.dbpt = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class index_retrieve_base // base class for various scan classes
{
protected:
  IID index_id;
  SMCURSOR cursor;
  KEY  cur_key;
  KEY  lower_key;
  KEY  upper_key;
  // a bunch of flags
  char lower_excl, upper_excl; // are lower/upper bounds inclusive or exclusive?
  char lower_set, upper_set;   // have bounds been set?
  char retrieve_started; 		// has scan been started?
  char reverse;
  char eq_retrieve;	// set if point comparision
  index_retrieve_base() 
  { lower_excl = 0; upper_excl = 0; 
    lower_set = 0; upper_set = 0; 
    retrieve_started = 0; eof = 1; 
    reverse = 0; errno = 0; 
    eq_retrieve = 0;
  };
  void fetch_init();
  void init_scan();
public:
  BOOL eof; 			// has end been reached?
  int errno;
  union {
    dbvoid * cur_elem; // 
    char dbpt_space[sizeof(dbvoid *)];
  };
  void next(); // advance cursor; set next element.
};
 
template <class t> class index_retrieve: public index_retrieve_base
{
	t lower_keyval;
	t upper_keyval;
public:
	t cur_keyval;
	// cur_elem pointer inherited from index_retrieve_base
	void retrieve_init()
	{
	  lower_key.valuePtr = &lower_keyval;
	  lower_key.length = sizeof(lower_keyval);
	  upper_key.valuePtr = &upper_keyval;
	  upper_key.length = sizeof(upper_keyval);
	  cur_key.valuePtr = &cur_keyval;
	  cur_key.length = sizeof(cur_keyval);
	};
	// single point retrieve
	index_retrieve(sm_index<t>& this_index,t test)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetEQ(test);
	};
	index_retrieve(sm_index<t> &this_index)   // no key; set later.
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	};

	index_retrieve(sm_index<t>& this_index,t lb, t up, int exl=0)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetLB(lb,exl);
	  SetUB(up,exl);
	};
	void SetEQ(t tval) 
	{ lower_keyval= tval; eq_retrieve =1; };
	void SetLB(t tval, int exclusive=0) 
	{ lower_keyval= tval; lower_excl = exclusive; lower_set =1; };
	void SetUB(t tval, int exclusive=0) 
	{ upper_keyval= tval; upper_excl = exclusive; upper_set =1; };
};

dbclass str_index
{

  public:
	IID index_id;
	int errno;
	int max_len;
	str_index(SMTYPE itype,int maxkey, BOOL uniqf=0);
	~str_index() { IID this_index_index; int rc;
	   this_index_index = index_id; 
	   rc = sm_DestroyIndex(&this_index_index,__Ebg);
	};
	insert(char * key,dbvoid * elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.dbpt = elt;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(char * key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.dbpt = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class str_index_retrieve: public index_retrieve_base
{
	char * lower_keyval;
	char * upper_keyval;
	int max_len;
public:
	char * cur_keyval;
	// single point retrieve
	str_index_retrieve(str_index& this_index,char * test)
	{
	  index_id = this_index.index_id;
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_index.max_len;
	  max_len = this_index.max_len;
	  SetLB(test);
	  SetUB(test);
	};
	str_index_retrieve(str_index& this_index,char * lb, char *ub,int excl=0)
	{
	  index_id = this_index.index_id;
	  // unfortunately we seem to need to allocate string space.
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_index.max_len;
	  max_len = this_index.max_len;
	  SetLB(lb,excl);
	  SetUB(ub,excl);
	};
	str_index_retrieve(str_index &this_index)   // no key; set later.
	{
	  cur_key.valuePtr = new char[this_index.max_len];
	  cur_key.length = this_index.max_len;
	  cur_keyval = (char *)cur_key.valuePtr;
	  max_len = this_index.max_len;
	  index_id = this_index.index_id;
	};
	~str_index_retrieve()
	{
		delete cur_keyval;
	}
	void
	next() { cur_key.length = max_len; index_retrieve_base::next();}

	void SetLB(char * tval, int exclusive=0) 
	{ lower_key.valuePtr = tval; lower_key.length = strlen(tval)+1;
	  lower_excl = exclusive; lower_set =1; };
	void SetUB(char * tval, int exclusive=0) 
	{ upper_key.valuePtr = tval; upper_key.length = strlen(tval)+1;
	  upper_excl = exclusive; upper_set =1; };
	void SetEQ(char * tval) 
	{ lower_key.valuePtr = tval; lower_key.length = strlen(tval)+1;
	  eq_retrieve = 1;
	}
};
// btree specific use of sm_index type: pass through correct parm to ctor
template <class key> dbclass BtreeIndex : public sm_index<key>
{
public:
	BtreeIndex(BOOL uniqf=0): sm_index<key> (SM_BTREENDX, uniqf) {};
	// all other ops inherited
};
// btree specific instance of index_retrieve
template <class key> class BtreeRetrieve: public index_retrieve<key>
{
	// single point retrieve
public:
	BtreeRetrieve( BtreeIndex<key>& this_index,key test)
		: index_retrieve<key> (this_index, test) {};
	BtreeRetrieve(sm_index<key> &this_index)   // no key; set later.
		: index_retrieve<key> (this_index){};
	BtreeRetrieve(BtreeIndex<key>& this_index,key lb, key up, int exl=0)
		: index_retrieve<key> (this_index, lb,  up,  exl){};
	// other operations are inherited.
};


// hash specific type: pass through correct parm to ctor
template <class key> dbclass HashIndex : public sm_index<key>
{
public:
	HashIndex(BOOL uniqf=0): sm_index<key>(SM_HASHNDX, uniqf) {};
	// all other ops inherited
};

// btree specific instance of index_retrieve
template <class key> class HashRetrieve: public index_retrieve<key>
{
public:
	// single point retrieve
	HashRetrieve( HashIndex<key>& this_index,key test)
		: index_retrieve<key> (this_index, test) {};
	// other ctors are not supported
};

#endif

