#ifndef _sm_btree_h
#define _sm_btree_h 1
#include <stdio.h>
#include <E/trans.h>
#include <E/sm_client.h>
extern VOLID __Evolid;
extern int __Ebg;
const int BLKLD_RunSize = 128; // 8k pages; about 1meg 
extern "C" void FlushCache();

union elem_un { dbvoid * dbpt; char space[sizeof(dbvoid *)];};
template <class t> dbclass btree
{

  public:
	IID index_id;
	int errno;
	btree(BOOL uniqf=0);
	~btree() { IID this_btree_index; int rc;
	   this_btree_index = index_id; 
	   rc = sm_DestroyIndex(&this_btree_index,__Ebg);
	};
	int
	BeginBulkLoad(int runsize = BLKLD_RunSize)
	{ IID this_btree_index; int rc;
	   this_btree_index = index_id; 
	   rc = sm_BeginIndexLoad(&this_btree_index,__Ebg,__Evolid,runsize);
	   if (rc) 
		errno = sm_errno;
	   return rc;
	};
	EndBulkLoad()
	{
	 IID this_btree_index; int rc;
		FlushCache();
	   this_btree_index = index_id; 
	   rc = sm_EndIndexLoad(&this_btree_index);
	   if (rc)
		errno = sm_errno;
	   return rc;
	};
	insert(t key,dbvoid * elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.dbpt = elt;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(t key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.dbpt = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = sizeof(key);
	  i_key.valuePtr = &key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class btree_retrieve_base // base class for various scan classes
{
protected:
  IID index_id;
  SMCURSOR cursor;
  KEY  cur_key;
  KEY  lower_key;
  KEY  upper_key;
  // a bunch of flags
  char lower_excl, upper_excl; // are lower/upper bounds inclusive or exclusive?
  char lower_set, upper_set;   // have bounds been set?
  char retrieve_started; 		// has scan been started?
  char reverse;
  btree_retrieve_base() 
  { lower_excl = 0; upper_excl = 0; 
    lower_set = 0; upper_set = 0; 
    retrieve_started = 0; eof = 1; 
    reverse = 0; errno = 0; 
  };
  void fetch_init();
  void init_scan();
public:
  BOOL eof; 			// has end been reached?
  int errno;
  union {
    dbvoid * cur_elem; // 
    char dbpt_space[sizeof(dbvoid *)];
  };
  void next(); // advance cursor; set next element.
};
 
template <class t> class btree_retrieve: public btree_retrieve_base
{
	t lower_keyval;
	t upper_keyval;
public:
	t cur_keyval;
	// cur_elem pointer inherited from btree_retrieve_base
	void retrieve_init()
	{
	  lower_key.valuePtr = &lower_keyval;
	  lower_key.length = sizeof(lower_keyval);
	  upper_key.valuePtr = &upper_keyval;
	  upper_key.length = sizeof(upper_keyval);
	  cur_key.valuePtr = &cur_keyval;
	  cur_key.length = sizeof(cur_keyval);
	};
	// single point retrieve
	btree_retrieve(btree<t>& this_btree,t test)
	{
	  index_id = this_btree.index_id;
	  retrieve_init();
	  SetLB(test);
	  SetUB(test);
	};
	btree_retrieve(btree<t> &this_btree)   // no key; set later.
	{
	  index_id = this_btree.index_id;
	  retrieve_init();
	};

	btree_retrieve(btree<t>& this_btree,t lb, t up, int exl=0)
	{
	  index_id = this_btree.index_id;
	  retrieve_init();
	  SetLB(lb,exl);
	  SetUB(up,exl);
	};
	void SetLB(t tval, int exclusive=0) 
	{ lower_keyval= tval; lower_excl = exclusive; lower_set =1; };
	void SetUB(t tval, int exclusive=0) 
	{ upper_keyval= tval; upper_excl = exclusive; upper_set =1; };
};

dbclass str_btree
{

  public:
	IID index_id;
	int errno;
	int max_len;
	str_btree(int maxkey, BOOL uniqf=0);
	~str_btree() { IID this_btree_index; int rc;
	   this_btree_index = index_id; 
	   rc = sm_DestroyIndex(&this_btree_index,__Ebg);
	};
	BeginBulkLoad()
	{ IID this_btree_index; int rc;
	   this_btree_index = index_id; 
	   rc = sm_BeginIndexLoad(&this_btree_index,__Ebg,__Evolid,BLKLD_RunSize);
	   if (rc)
		errno = sm_errno;
	   return rc;
	};
	EndBulkLoad()
	{ IID this_btree_index; int rc;
	   this_btree_index = index_id; 
	   rc = sm_EndIndexLoad(&this_btree_index);
	   if (rc)
		errno = sm_errno;
	   return rc;
	};
	insert(char * key,dbvoid * elt)
	{
	  int rc;
	  elem_un ent_un;
	  IID iid = index_id;
	  KEY i_key;
	  ent_un.dbpt = elt;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_InsertEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
	remove(char * key,dbvoid *elt)
	{
	  int rc;
	  elem_un ent_un;
	  ent_un.dbpt = elt;
	  IID iid = index_id;
	  KEY i_key;
	  i_key.length = strlen(key)+1;
	  i_key.valuePtr = key;
	  rc = sm_RemoveEntry(&iid,__Ebg,&i_key,&ent_un);
	  return rc;
	}
};

class str_btree_retrieve: public btree_retrieve_base
{
	char * lower_keyval;
	char * upper_keyval;
	int max_len;
public:
	char * cur_keyval;
	// single point retrieve
	str_btree_retrieve(str_btree& this_btree,char * test)
	{
	  index_id = this_btree.index_id;
	  cur_key.valuePtr = new char[this_btree.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_btree.max_len;
	  max_len = this_btree.max_len;
	  SetLB(test);
	  SetUB(test);
	};
	str_btree_retrieve(str_btree& this_btree,char * lb, char *ub,int excl=0)
	{
	  index_id = this_btree.index_id;
	  // unfortunately we seem to need to allocate string space.
	  cur_key.valuePtr = new char[this_btree.max_len];
	  cur_keyval = (char *)cur_key.valuePtr;
	  cur_key.length = this_btree.max_len;
	  max_len = this_btree.max_len;
	  SetLB(lb,excl);
	  SetUB(ub,excl);
	};
	str_btree_retrieve(str_btree &this_btree)   // no key; set later.
	{
	  cur_key.valuePtr = new char[this_btree.max_len];
	  cur_key.length = this_btree.max_len;
	  cur_keyval = (char *)cur_key.valuePtr;
	  max_len = this_btree.max_len;
	  index_id = this_btree.index_id;
	};
	~str_btree_retrieve()
	{
		delete cur_keyval;
	}
	void
	next() { cur_key.length = max_len; btree_retrieve_base::next();}

	void SetLB(char * tval, int exclusive=0) 
	{ lower_key.valuePtr = tval; lower_key.length = strlen(tval)+1;
	  lower_excl = exclusive; lower_set =1; };
	void SetUB(char * tval, int exclusive=0) 
	{ upper_key.valuePtr = tval; upper_key.length = strlen(tval)+1;
	  upper_excl = exclusive; upper_set =1; };
};
#endif
