#ifndef _gen_sm_index_h
#define _gen_sm_index_h 1
// generic part of Exodus storage manager index inteface classes.
// There are 2 class templates defined here: sm_index<t> 
// and index_retrieve<t>.  These classes should not be used
// directly; they are meant to be used for further derivation
// of more use-specifice templates; see E/BtreeIndex.h and E/HashIndex.h
#include <stdio.h>
#include <E/trans.h>
#include <E/sm_client.h>
extern VOLID __Evolid;
extern int __Ebg;

union elem_un { dbvoid * dbpt; char space[sizeof(dbvoid *)];};
template <class t> dbclass sm_index
{
  public:
	IID index_id;
	int errno;
	sm_index(SMTYPE itype= SM_BTREENDX,BOOL uniqf=0);
	~sm_index() { IID this_index_index; int rc;
	    this_index_index = index_id; 
	    rc = sm_DestroyIndex(&this_index_index,__Ebg);
	 };
	insert(t key,dbvoid * elt);
	remove(t key,dbvoid *elt);
	removeall(t key); // remove all elements associated with key.
};

class index_retrieve_base // base class for various scan classes
{
protected:
  IID index_id;
  SMCURSOR cursor;
  KEY  cur_key;
  KEY  lower_key;
  KEY  upper_key;
  // a bunch of flags
  char lower_excl, upper_excl; // are lower/upper bounds inclusive or exclusive?
  char lower_set, upper_set;   // have bounds been set?
  char retrieve_started; 		// has scan been started?
  char reverse;
  char eq_retrieve;	// set if point comparision
  index_retrieve_base() 
  { lower_excl = 0; upper_excl = 0; 
    lower_set = 0; upper_set = 0; 
    retrieve_started = 0; eof = 1; 
    reverse = 0; errno = 0; 
    eq_retrieve = 0;
  };
  void fetch_init();
  void init_scan();
public:
  BOOL eof; 			// has end been reached?
  int errno;
  union {
    dbvoid * cur_elem; // 
    char dbpt_space[sizeof(dbvoid *)];
  };
  void next(); // advance cursor; set next element.
};
 
template <class t> class index_retrieve: public index_retrieve_base
{
	t lower_keyval;
	t upper_keyval;
public:
	t cur_keyval;
	// cur_elem pointer inherited from index_retrieve_base
	void retrieve_init() ;
	// single point retrieve
	index_retrieve(sm_index<t>& this_index,t test)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetEQ(test);
	};
	index_retrieve(sm_index<t> &this_index)   // no key; set later.
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	};

	index_retrieve(sm_index<t>& this_index,t lb, t up, int exl=0)
	{
	  index_id = this_index.index_id;
	  retrieve_init();
	  SetLB(lb,exl);
	  SetUB(up,exl);
	};
	void SetEQ(t tval) ;
	void SetLB(t tval, int exclusive=0) ;
	void SetUB(t tval, int exclusive=0) ;
	// we'd like this out of line too, but the
	// compiler chokes.
	~index_retrieve()  
	{
		// if (lower_key.valuePtr !=(char *)(&lower_keyval))
		// 	delete lower_key.valuePtr;
		// if (upper_key.valuePtr !=(char *)(&upper_keyval))
	// 		delete upper_key.valuePtr;
		if (cur_key.valuePtr !=(char *)(&cur_keyval))
			delete cur_key.valuePtr;
	}
};

#endif

