/* -*- c++ -*-
   Map source file and line number to counters */

#ifndef _BPROF_SOURCES_H
#define _BPROF_SOURCES_H

#pragma interface

#include <std.h>
#include <String.h>

class sourcefile {
    String filename;
    int numlines;		// Number of lines in file + 1
    int* lines;			// Array of number of ticks
    int dummy;
    time_t _mtime;
public:
    sourcefile(String, int);
    ~sourcefile(void);
    int& operator[](unsigned int);
    void paste(const char* = ".bprof");
    time_t mtime(void) const;

    // Make sure no default assignment/copy constructor exists
    sourcefile& operator=(const sourcefile &) { abort(); } // Not possible
    sourcefile(const sourcefile &) { abort(); } // Not possible
};

typedef sourcefile* sfpnt;

class dirset {
    struct dirlink {		// Linked list of dirs
	dev_t dev;
	ino_t ino;
	dirlink* next;
    };
    dirlink* first;
public:
    dirset(void);
    ~dirset(void);
    void operator+=(const char *); // Add a directory
    int contains(const char *);	   // Look if a directory is in there
};

#endif // _BPROF_SOURCES_H
