#include <fstream.h>
#include <sys/stat.h>
#include "sources.h"

sourcefile::sourcefile(String name, int really)
{
    filename = name;

    if (!really) {
	lines = 0;
	return;
    }
    
    ifstream from(name);
    if (!from) {
	lines = 0;
	return;
    }

    /* Count the number of lines in the sourcefile.
       Numlines is actually one larger than this. */
    numlines = 1;
    char* ch;
    while (from.gets(&ch)) {
	delete[] ch;
	numlines++;
    }

    lines = new int[numlines];
    memset(lines, -1, numlines * sizeof(int));
    /* The above line assumes that this will make -1 out
       of them */

    stat flstat;
    if (stat(name, &flstat)) {
	cerr << "Warning: could not stat " << name << '\n';
        _mtime = 0;
	return;
    }
    _mtime = flstat.st_mtime;
}

sourcefile::~sourcefile(void)
{
    delete[] lines;
}

int& sourcefile::operator[](unsigned int nr)
{
    if (!lines)
	return dummy;

    if (nr >= numlines) {
	cerr << "Warning: debug info indicates line " << nr << " in file " << filename
	    << "\nwhich seems to have only " << (numlines-1) << " lines\n";
	return dummy;
    }

    if (lines[nr] == -1)
	lines[nr] = 0;
    return lines[nr];
}

void sourcefile::paste(const char *suffix)
{
    if (!lines)
	return;

    // Should check length with pathconf(".", _PC_NAME_MAX)
    String outname(filename + suffix);
    unlink(outname);		// opening with ios::trunc doesn't seem to work ???
    ofstream to(outname);
    if (!to) {
	cerr << "Could not open " << outname << " to write to\n";
	return;
    }
    
    ifstream from(filename);
    if (!from) {
	cerr << "Could not open " << filename << " for input\n";
	return;
    }

    for (int i = 1; i < numlines; i++) {
	if (lines[i] == -1)
	    to << "     .";
	else if (lines[i] == 0)
	    to << "     -";
	else {
	    to.width(6);
	    to << lines[i];
	}
	char* ch;
	from.gets(&ch);
	to << '\t' << ch << '\n';
	delete[] ch;
    }
}

time_t sourcefile::mtime(void) const
{
    return lines ? _mtime : 0;
}

dirset::dirset(void)
{
    first = 0;
}

dirset::~dirset(void)
{
    dirlink* nxt;
    for (dirlink* i = first; i; i = nxt) {
	nxt = i->next;
	delete i;
    }
}

void dirset::operator+=(const char *name)
{
    stat dirstat;
    if (stat(name, &dirstat))
	return;
    dirlink* newdir = new dirlink;
    newdir->dev = dirstat.st_dev;
    newdir->ino = dirstat.st_ino;
    newdir->next = first;
    first = newdir;
}

int dirset::contains(const char *name)
{
    stat dirstat;
    if (stat(name, &dirstat))
	return 0;
    for (dirlink* i = first; i; i = i->next) {
	if (dirstat.st_dev == i->dev &&
	    dirstat.st_ino == i->ino)
	    return 1;
    }
    return 0;
}
