/* Main source file for bprof. */

#include <std.h>
#include <GetOpt.h>
#include "String.sfpnt.VHMap.h"
#include "bmonout.h"
#include "execute.h"
#include "sources.h"

int main(int argc, char** argv)
{
    String suffix(".bprof");	// Default suffix
    dirset gooddirs;
    gooddirs += ".";		// Always use pwd

    GetOpt getopt(argc, argv, "s:d:");
    int option;
    while ((option = getopt()) != EOF) {
	switch (option) {
	case 'd':
	    gooddirs += getopt.optarg;
	    break;
	case 's':
	    suffix = getopt.optarg;
	    break;
	case '?':
	    exit(1);
	}
    }

    // First non-option argument is executable
    const char* filename;
    if (getopt.optind < argc) {
	filename = argv[getopt.optind++];
    } else {
	filename = "a.out";
    }
    executable aout(filename);
    
    // Other non-options args are bmon.out files
    int numbmon = argc - getopt.optind;
    bmonout** bmon;		// Array of bmonout pointers
    if (numbmon) {
	bmon = new bmonout * [numbmon];
	for (int i = 0; i < numbmon; i++) {
	    bmon[i] = new bmonout(argv[getopt.optind]);
	    if (bmon[i]->mtime() < aout.mtime()) {
		cerr << "Warning: executable is newer than " << argv[getopt.optind] << '\n';
	    }
	    getopt.optind++;
	}
    } else {
	numbmon = 1;
	bmon = new bmonout*[numbmon];
	bmon[0] = new bmonout;
	if (bmon[0]->mtime() < aout.mtime()) {
	    cerr << "Warning: executable is newer than bmon.out\n";
	}
    }

    StringsfpntVHMap source(0);

    do {
	String cname;
	if (aout.filename()[0] == '/') {
	    cname = aout.filename();
	} else {
	    cname = aout.dirname();
	    cname += aout.filename();
	}

	if (!source.contains(cname)) {
	    int lastslash = cname.index("/",-1);
	    String dir = cname.before(lastslash);
	    int really = gooddirs.contains(dir);
	    source[cname] = new sourcefile(cname, really);
	    if (aout.mtime() < source[cname]->mtime())
		cerr << "Warning: source file " << cname << " newer than executable\n";
	}

	sourcefile& sfile = *source[cname];
	for (unsigned long i = aout.lowpc(); i < aout.highpc(); i++) {
	    unsigned int count = 0;
	    for (int j = 0; j < numbmon; j++) {
		count += (*bmon[j])[i];
	    }
	    sfile[aout.lineno()] += count;
	}
    } while (aout.shift());

    for (int i = 0; i < numbmon; i++) {
	delete bmon[i];
    }
    delete[] bmon;

    // Write the source files with data
    for (Pix p = source.first(); p; source.next(p)) {
	source.contents(p)->paste(suffix);
    }

    return 0;
}
