########################################
# ts.tcl
########################################

# Procedures

proc debug {s} {
  global params

  if $params(debug) { puts $s }
}

proc filetest {f1 {f2 ""}} {
  if ![file exist $f1] {
    return 1
  }
  if {$f2 == ""} {return 0}
  if ![file exist $f2] {
    return 2
  }
  if {[file mtime $f1] > [file mtime $f2]} {
    return 3
  }
  return 0
}

proc cutdir {path} {
  global params

  if {[string first $params(Primary_dir) $path] == 0} {
    set s [string range $path [string length $params(Primary_dir)] end]
    if {[cindex $s 0] == "/"} {
      set s [string range $s 1 end]
    }
    return $s
  }
  return $path
}

# proc scanopt replaces  %-parameters
#  %p - Primary file (without extension)
#  %e - Editfile -> Filedialog
#  %o - Other file -> Filedialog
#  %g - Geometry 
# Print options !... ! cleared

proc scanopt {s {geom ""}} {
  global params prd

  debug "scanopt: $s"
  set l [clength $s]
  set t ""
  for {set i 0} {$i < $l} {incr i} {
    if {[set c [cindex $s $i]] == "%"} {
      incr i
      set c [cindex $s $i]
      switch $c {
        p {
          if {$params(Primary_file) != ""} { 
            set t $t$params(Primary_file)
          } elseif {$params(Edit_file) != ""} {
            set t $t[file rootname [cutdir $params(Edit_file)]]
          } else {
            Warning $params(dlg_geom) \
              "No Primary file is specified.\nNo Edit file was found."
            return ""
          }
        }
        e {
           set t $t$params(Edit_file)
        }
        o {
          set ext ""
          incr i
          while {$i < $l && [set c [cindex $s $i]] != " "} {
            set ext $ext$c
            incr i
          }
          set f ""
          if {![FileDialog $params(dlg_geom) "Select File" $ext f]} {
            return ""
          }
          if {[file tail $f] != ""} {
            set t $t[cutdir $f]
          }
        }
        g {
          if {$geom == ""} {
            set geom $params(default_geom)
          }
          set t $t$geom
        }
      }
    } elseif {$c == "!"} {
      incr i
      while {$i < $l && [set c [cindex $s $i]] != "!"} {incr i}
      incr i
    } else { ; # default chars
      set t $t$c
    }
  }
  debug "scanopt ready: $t"
  return $t
}

# setprintopt s opt
# sets printeroption opt in s
# Options:
#   landscape -> !l..!
#
proc setprintopt {str opt {value ""}} {
  upvar $str s

  debug "Setprintopt: $s"
  switch $opt {
    landscape {
      set i [string first "!l" $s]
    }
    first {
      set i [string first "!0" $s]
    }
    last {
      set i [string first "!9" $s]
    }
    copies {
      set i [string first "!c" $s]
    }
    odd {
      set i [string first "!o" $s]
    }
    even {
      set i [string first "!e" $s]
    }
    xopt {
      set i [string first "!x" $s]
    }
    default {return 0}
  }
  set l [string length $s]
  if {$i < 0} {return 0}
  set t [string range $s 0 [expr $i -1]]
  for {incr i 2} {$i < $l && [set c [cindex $s $i]] != "!"} {incr i} {
    if {$c == "%"} {
      if {$value != ""} {
        set t $t$value
      } else {
        return 0
      }
    } else {
      set t $t$c
    }
  }
  set s $t[string range $s [expr $i + 1] end]
  debug "Setprintopt ready: $s"
  return 1
}

proc EvalCmd {cmdline {geom ""}} {
  global params pid

  debug "EvalCmd: $cmdline"
  set cmd [lindex $cmdline 1]
  set opt [lindex $cmdline 2]
  if {[set opt [scanopt $opt $geom]] == ""} {
    return
  }
  debug "Work directory: $params(Primary_dir)"
  debug "Cmd: $cmd Opt: $opt"
  switch $cmd {
    exwin {
      set cmd [lindex $opt 0]
      set opt [lrange $opt 1 end]
      OutMsg "$cmd $opt\n"
      ExecCmd  $cmd $opt
    }
    exbg {
      set epid [eval exec $opt >@$params(ow) 2>@$params(ew) &]
      set epid [lindex $epid 0]
      lappend pid [list $epid $opt] 
      OutMsg "Process id($epid) was started: $opt"
    }
    exec {
      OutMsg $opt
      catch {eval exec $opt} out
      OutMsg $out
    }
    default {
      OutMsg "$cmd $opt"
      eval $cmd $opt
    }
  }
}

proc Zeit {} {
  return [fmtclock [getclock] "%H:%M:%S"]
}

proc Out {w s} {
  global params

  $w mark set insert end
  set pos [$w index insert]
  set l [ctoken pos "."]
  set c [ctoken pos "."]
  if {$c != 0} {
    $w insert insert \n
  }
  if {$l > $params(hist_max)} {
    $w delete 1.0 [expr $l - $params(hist_min)].0
  }
  set pos [$w index insert]
  $w insert insert $s
  $w yview -pickplace $pos
}

proc OutMsg {s} {
  Out .t.text "+ [Zeit] $s"
}

proc OutErr {s} {
  Out .t.text  "??? $s ???\n"
}

proc OutClr {} {
  .t.text delete 1.0 end
  update
}

proc xfocus {w} {
  global params ted
  set old_focus [focus]
  catch {$old_focus configure -foreground #7f7f7f}
  focus $w
  raise [set wt [winfo toplevel $w]]
  catch {$w configure -foreground blue}
  catch {set params(Edit_file) $ted($wt,file)}
}

proc Exit {} {
  global params env

  set ex_ok 1
  for {set i 0} {$i < 10} {incr i} {
    if [winfo exists .t$i] {
      if ![TedExit .t$i] {set ex_ok 0}
    }
  }
  if {!$ex_ok} {
    return
  }
  StopTty
  writeparams $env(HOME)/.texshell
#PROF  profile off prof
#PROF  profrep prof cpu ts.profile
  exit
}

proc Kill {} {
  global params pid

  if {$pid == {}} {return}
  if {[set i \
      [ListDlg .ldlg 300x150$params(dlg_geom) "Kill Process:" $pid] \
      ] > -1} {
    kill SIGINT [lindex [lindex $pid $i] 0]
  }
}

proc Primary {} {
  global params

  if {$params(Primary_file) != ""} {
    set f $params(Primary_file).tex
  } else {
    set f ""
  }
  if {![FileDialog $params(dlg_geom) "Primary File" .tex f]} {return 0}
  set params(Primary_dir) [file dirname $f]
  cd $params(Primary_dir)
  set f [file tail $f]
  set params(Primary_file) [file rootname $f]
  OutMsg "Primary file was changed to $params(Primary_file)"
  OutMsg "Working directory is now    $params(Primary_dir)"
  return 1
}

proc EditFile {file {line 1}} {
  global params ted

  set lcmd [lindex $params(Edit) $params(Edit_default)]
  set cmd [lindex $lcmd 1]
  if {$cmd == "tedit"} {
    for {set i 0} {$i < 10} {incr i} {
      if [winfo exists .t$i] {
        if {$ted(.t$i,file) == $file} {
          raise .t$i
          xfocus .t$i.text
          .t$i.text mark set insert $line.0
          .t$i.text yview -pickplace insert
          return
        }
      }
    }
    set i 1
    while {[winfo exists .t$i]} {incr i}
    if {$i >= 10} {
      Warning $params(dlg_default) "Too many editors (max. 9)."
      return
    }
    set geom +[expr $params(x0) + 50 + 30 * $i]+[expr 50 + 30 * $i]
    tedit .t$i $geom "Edit - $i" $file $line
  } else {
    set opt [lindex $lcmd 2]
    if {[set i [string first "!i" $opt]] >= 0} {
      set s [string range $opt 0 [expr $i - 1]]
      set l [string length $opt]
      for {incr i 2} {[set c [cindex $opt $i]] != "!" && $i < $l} {incr i} {
        if {$c == "%"} {
          set s $s$line
        } else {
          set s $s$c
        }
      }
      set opt $s[string range $opt [expr $i + 1] end]
    }
    set params(Edit_file) $file
#    if {[set i [string first "%e" $opt]] >= 0} {
#      set s [string range $opt 0 [expr $i - 1]]$file
#      set l [string length $opt]
#      for {incr i 2} {$i < $l && [cindex $opt $i] != " "} {incr i} { }
#      set opt $s[string range $opt [expr $i + 1] end]
#    } else {
#      Warning $params(dlg_geom) \
#        "Error in Editor file parameter.\nMust be `%e'."
#      return
#    }
    EvalCmd [list Edit $cmd $opt]
  } 
}
      
proc Edit {{i ""}} {
  global params

  set lcmd [lindex $params(Edit) $params(Edit_default)]
  set cmd [lindex $lcmd 1]
  # eval geometry for external Editor
  if {$cmd != "tedit"} {
    set ext [file extension $params(Edit_file)]
    if {$ext == ""} {set ext .tex}
    if {![FileDialog $params(dlg_geom) "Select File" $ext \
      params(Edit_file)]} {return ""}
    set params(Edit_file) [cutdir $params(Edit_file)]
    EvalCmd $lcmd
    return
  }
  if {$i != ""} {
    if {[winfo exists .t$i]} {
      raise .t$i
      xfocus .t${i}.text
      return
    }
  } else {
    set i 1
    while {[winfo exists .t$i]} {incr i}
    if {$i >= 10} {
      Warning $params(dlg_default) "Too many editors (max. 9)."
      return
    }
  }
  set geom +[expr $params(x0) + 50 + 30 * $i]+[expr 50 + 30 * $i]
  if {![FileDialog $params(dlg_geom) "Select File" .tex \
    params(Edit_file)]} {return ""}
  set opt ".t$i $geom \"Edit - $i\" $params(Edit_file)"
  if {$opt != ""} {eval tedit $opt} 
}

proc EditPrim {} {
  global params
  
  set lcmd [lindex $params(Edit) $params(Edit_default)]
  set cmd [lindex $lcmd 1]
  if {$params(Primary_file) == ""} {
    if {![Primary]} return
    if {$params(Primary_file) == ""} {
      Warning $params(dlg_geom) "No primary file is specified."
      return
    }
  }
  set params(Edit_File) $params(Primary_file).tex
  if {$cmd == "tedit"} {
    if {[winfo exists .t0]} {
      raise .t0
      xfocus .t0.text
    } else {
      set x [expr $params(x0)+50]
      tedit .t0 +$x+50 "Edit - 0" \
        $params(Primary_dir)/$params(Primary_file).tex
    }
  } else {
    EditFile $params(Primary_file).tex 1
  }
}

proc Compose {} {
  global params

  # Save last edit file, because Saving will change this
  set edfile $params(Edit_file)
  for {set i 0} {$i < 10} {incr i} {
    if [winfo exists .t$i] {
      if {![TedAskSave .t$i]} {return}
    }
  }
  set params(Edit_file) $edfile
  set l [lindex $params(Compose) $params(Compose_default)]
  unlink -nocomplain compose.err
  EvalCmd $l
  if {[file exists compose.err]} { ;# Error occured, Edit was called
    set fd [open compose.err r]
    set s [read $fd]
    set line [ctoken s " \n"]
    set file [ctoken s " \n"]
    close $fd
    unlink -nocomplain compose.err
    if {[cindex $file 0] != "/"} {
      set file $params(Primary_dir)/$file
    }
    EditFile $file $line
  }
}

proc Reference {} {
  global params

  set l [lindex $params(Reference) $params(Reference_default)]
  EvalCmd $l
}

proc View {} {
  Output View
}

proc Print {} {
  Output Print
}

proc Output {{device View}} {
  global params prd

  if {$params(Primary_file) != ""} {
    set f $params(Primary_file)
  } elseif {$params(Edit_file) != ""} {
    set f [file rootname $params(Edit_file)]
  } else {
    Warning $params(dlg_geom) "No Primary file is specified."
    return
  }

  switch [filetest ${f}.tex ${f}.dvi] {
    1 {
      Warning $params(dlg_geom) "TeX file ${f}.tex not found"
      return
    }
    2 {
      if {[Dialog .dlg $params(dlg_geom) "" \
        "DVI file $f.dvi not found.\n Run compose?" question \
        0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
        Compose
      } else {
        return
      }
    }
    3 {
      if {[Dialog .dlg $params(dlg_geom) "" \
        "Primary file $f has been changed.\nRun compose?" question \
        0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
        Compose
        debug "View weiter"
      }
    }
  }
  set l [lindex $params($device) $params(${device}_default)]
  # .ps test
  set cmd [lindex $l 1]
  set opt [lindex $l 2]
  if {[string first "%p.ps" $opt] != -1} {
    switch [filetest ${f}.dvi ${f}.ps] {
      1 {
        Warning $params(dlg_geom) "Could not compose DVI file ${f}.dvi."
        return
      }
      default {
        OutMsg "Generate new PostScript file."
        EvalCmd [list MakePS exwin "dvips -o%p.ps %p"]
      }
    }
  } 
  if {$device == "View"} {
    EvalCmd $l
    return
  }
  # Printing
  if {![PrintDlg $params(dlg_geom) [cutdir "${f}.dvi"] params]} {
    return
  }
  if {$params(pr_first) != "" && $params(pr_first) > 1} {
    setprintopt opt first $params(pr_first)
  }
  if {$params(pr_last) != "" && $params(pr_last) < 9999} {
    setprintopt opt last $params(pr_last)
  }
  if {$params(pr_copies) != "" && $params(pr_copies) > 1} {
    setprintopt opt copies $params(pr_copies)
  }
  if {$params(pr_xopt) != ""} {
    setprintopt opt xopt $params(pr_xopt)
  }
  if {$params(pr_orientation) == "landscape"} {
    if {![setprintopt opt landscape]} {
      Warning $params(dlg_geom) \
        "DVI Driver can't print in landscape mode.\nAbort."
      return
    }
  }
  switch $params(pr_pages) {
    all { }
    odd {setprintopt opt odd}
    even {setprintopt opt even}
  }
  set l [list Print $cmd $opt]
  EvalCmd $l
}

proc Graphic {} {
  global params

  set l [lindex $params(Graphic) $params(Graphic_default)]
  EvalCmd $l
}

proc Util {{i 0}} {
  global params

#  set l {}
#  foreach i $params(Util) {
#    lappend l [lindex $i 0]
#  }
#  if {[set i \
#      [ListDlg .ldlg 300x150$params(dlg_geom) "Utilities:" $l \
#        $params(Util_default)] ] > -1} {
    set l [lindex $params(Util) $i]
    EvalCmd $l
#  }
}

proc setparam {cmd entry} {
 global params

 set params(${cmd}_cmd) [lindex $entry 1]
}

proc ShowOut {} {
  global params

  if {$params(ShowOut)} {
    wm deiconify .t
  } else {
    wm withdraw .t
  }
}

# Main
proc main {} {
  global params pid argc argv env hlp

  readparams $env(HOME)/.texshell
  ide
  # Overwrite standard action for Button 1 (set focus)
  set textbind [bind Text <1>]
  set i [string last focus $textbind]
  bind Text <1> \
  [string range $textbind 0 [expr $i-1]]x[string range $textbind $i end]
  debug [bind Text <1>]
  #bind .c.lprimary <2> {set params(Primary_file) [selection get]}

  if $argc>0 {
    set f [lindex $argv 0]
    set params(Primary_dir) [file dirname $f]
    cd $params(Primary_dir)
    set f [file tail $f]
    set params(Primary_file) [file rootname $f]
  }
  if {$params(Primary_dir) == "."} {
    set params(Primary_dir) [pwd]
  }
  set env(TEXEDIT) "$params(ts_dir)/err %d %s"
  signal trap SIGCHLD {CmdKill}
  StartTty
  foreach P {Edit Compose View Print Util Graphic} {
    set params(${P}_pid) 1
  }
  ref_tell [glob $hlp(dir)/*.hlp]
  update
  OutMsg "TeXShell (Jens Poenisch: poenisch@wirtschaft.tu-chemnitz.de)"
  OutMsg "Version $params(version)"
  OutMsg "  Primary file:      $params(Primary_file)"
  OutMsg "  Working directory: $params(Primary_dir)"
  OutMsg "  Help: Press F1"
  OutMsg ""
  OutMsg "  Please correct the settings for external editors if you have"
  OutMsg "  used a version before 95/03/05!"
  OutMsg "  Press Ctrl-F3, select your editor and remove the extension"
  OutMsg "  after %e."
} 
