# Construct IDE interface

proc utilmenu {} {
  global params

# Add dummy for correct deleting
  .b.butil.m add separator
  .b.butil.m delete 4 last
  if {$params(Util) != {}} {
    .b.butil.m add separator
    set i 1
    foreach l $params(Util) {
      .b.butil.m add command -label "$i [lindex $l 0]" -underline 0 \
        -command "Util [expr $i -1]" -font fixed
      incr i
    }
  }
}
proc ide {} {
  global params

  wm geometry . +5+5
  wm title . TeXShell
  wm iconbitmap . @$params(icon_dir)/tex.ico

  # Regions
  frame .b
  frame .c
  pack .b .c -fill x

  # Command Buttons
  frame .b.fprimary -relief raised -borderwidth 1
  pack .b.fprimary -side top -fill x
  button .b.fprimary.b -text "F13 Primary file" -font fixed \
    -command Primary
  label .b.fprimary.l -bitmap @$params(icon_dir)/texfile.ico
  label .b.fprimary.p -textvariable params(Primary_file) -font fixed \
    -background white
  if {$params(showicons)} {
    pack .b.fprimary.l -side right
  }
  pack .b.fprimary.b -side top -fill x
  pack .b.fprimary.p -side top -fill x -padx 2 -pady 2
    
  frame .b.fedit -relief raised -borderwidth 1
  pack .b.fedit -side top -fill x
  button .b.fedit.b -text "F3 Edit" -font fixed -command Edit
  label .b.fedit.l -bitmap @$params(icon_dir)/edit.ico
  label .b.fedit.p -textvariable params(Edit_name) -font fixed -bg white \
    -width 16
  if {$params(showicons)} {
    pack .b.fedit.l -side right
  }
  pack .b.fedit.b -side top -fill x
  pack .b.fedit.p -side top -fill x -padx 2 -pady 2

  frame .b.fgraph -relief raised -borderwidth 1
  pack .b.fgraph -side top -fill x
  button .b.fgraph.b -text "F5 Graphic" -font fixed -command Graphic
  label .b.fgraph.l -bitmap @$params(icon_dir)/xfig.ico
  label .b.fgraph.p -textvariable params(Graphic_name) -font fixed -bg white
  if {$params(showicons)} {
    pack .b.fgraph.l -side right
  }
  pack .b.fgraph.b -side top -fill x
  pack .b.fgraph.p -side top -fill x -padx 2 -pady 2

  frame .b.fcompose -relief raised -borderwidth 1
  pack .b.fcompose -side top -fill x
  button .b.fcompose.b -text "F6 Compose" -font fixed -command Compose
  label .b.fcompose.l -bitmap @$params(icon_dir)/tex.ico
  label .b.fcompose.p -textvariable params(Compose_name) -font fixed -bg white
  if {$params(showicons)} {
    pack .b.fcompose.l -side right
  }
  pack .b.fcompose.b -side top -fill x
  pack .b.fcompose.p -side top -fill x -padx 2 -pady 2

  frame .b.fref -relief raised -borderwidth 1
  pack .b.fref -side top -fill x
  button .b.fref.b -text "F7 Reference" -font fixed -command Reference
  label .b.fref.l -bitmap @$params(icon_dir)/ref.ico
  label .b.fref.p -textvariable params(Reference_name) -font fixed -bg white
  if {$params(showicons)} {
    pack .b.fref.l -side right
  }
  pack .b.fref.b -side top -fill x
  pack .b.fref.p -side top -fill x -padx 2 -pady 2

  frame .b.fview -relief raised -borderwidth 1
  pack .b.fview -side top -fill x
  button .b.fview.b -text "F8 View" -font fixed -command View
  label .b.fview.l -bitmap @$params(icon_dir)/xdvi.ico
  label .b.fview.p -textvariable params(View_name) -font fixed -bg white
  if {$params(showicons)} {
    pack .b.fview.l -side right
  }
  pack .b.fview.b -side top -fill x
  pack .b.fview.p -side top -fill x -padx 2 -pady 2

  frame .b.fprint -relief raised -borderwidth 1
  pack .b.fprint -side top -fill x
  button .b.fprint.b -text "F9 Print" -font fixed -command Print
  label .b.fprint.l -bitmap @$params(icon_dir)/printer.ico
  label .b.fprint.p -textvariable params(Print_name) -font fixed -bg white
  if {$params(showicons)} {
    pack .b.fprint.l -side right
  }
  pack .b.fprint.b -side top -fill x
  pack .b.fprint.p -side top -fill x -padx 2 -pady 2

  menubutton .b.butil -text "F11 Utils" -menu .b.butil.m \
    -relief raised -font fixed
  menu .b.butil.m
  .b.butil.m add checkbutton -label "Show Output" -underline 0 -font fixed \
    -variable params(ShowOut) -command ShowOut
  .b.butil.m add command -label "Clear Output" -underline 0 -font fixed \
    -command OutClr
  .b.butil.m add command -label "Kill Process" -underline 0 -font fixed \
    -command Kill  
  .b.butil.m add command -label "Options..." -underline 0 -font fixed \
    -command Options
  utilmenu
    
  button .b.bexit -text "Alt-X   Exit" -font fixed -command Exit
  pack .b.butil .b.bexit -side left -fill x -expand 1
  # Bindings
  bind .b.fedit.b	<Button-3> "selectparams Edit"
  bind .b.fcompose.b	<Button-3> "selectparams Compose"
  bind .b.fref.b	<Button-3> "selectparams Reference"
  bind .b.fview.b	<Button-3> "selectparams View"
  bind .b.fprint.b	<Button-3> "selectparams Print"
  bind .b.fgraph.b	<Button-3> "selectparams Graphic"
  bind .b.butil		<Button-3> "selectparams Util"
  GlobalBind .
  bind . <F1>         "help"
  update

  # Output window
  toplevel .t
  wm group . .t
  set x [expr [winfo rootx .]+[winfo width .]+10]
  wm geometry .t +${x}+5
  wm title .t "Log Window"
  wm minsize .t 0 0
  wm withdraw .t
  frame .t.ftext
  pack .t.ftext -fill both -expand true
  pack .t.ftext

  text .t.text -width 80 -height 24 -yscrollcommand {.t.sb set} \
    -relief sunken -wrap word -font fixed -fg #6f6f6f
  scrollbar .t.sb -command {.t.text yview}
  pack .t.sb -side right -fill y -anchor e -in .t.ftext
  pack .t.text -side left -expand true -fill both -in .t.ftext
  bind .t.text <Any-Key> { }
  GlobalBind .t.text

  # Save dialog geometry
  update
  set x [expr [winfo rootx .]+[winfo width .]+10]
  set y [winfo rooty .]
  set params(dlg_geom) +$x+$y
  set params(x0) $x
  debug $params(dlg_geom)
  # Save default window geometry
  set params(default_geom) +$params(x0)+0
  ShowOut
  xfocus .
  focus default .
}
