/* kpsefind -- locate files using Kpathsea, optionally pretending to be
   a given program. For example,
     prompt$ kpsefind -tfm cmr10
     prompt$ kpsefind -p latex -tex language.dat
     prompt$ kpsefind -m ljfour -pk cmr10.600

   Originally written by Thomas Esser <te@informatik.uni-hannover.de>.
 */

#include <stdio.h> /* for stderr */
/* Karl: this next line works for me. Change it (if you like) to
   whatever you want.
 */
#include <kpathsea/tex-file.h>

extern char *kpse_var_expand ();
extern void kpse_set_progname ();
extern void kpse_init_prog ();
static void help();

/* The following are not (yet) in kpathsea.
   This will (hopely) change soon! In this case,
   these lines *MUST BE DELETED*.
 */
#define kpse_texpool_format	kpse_last_format
#define kpse_mfpool_format	kpse_last_format
#define kpse_fmt_format		kpse_last_format
#define kpse_base_format	kpse_last_format

static string progname;

int
main (argc, argv)
    int argc;
    char *argv[];
{
  kpse_file_format_type file_format;
  string mode = "cx", filetype, file, found;
  string virtname;

  progname=argv[0];
  virtname=progname; /* may be changed by "-n" option */

  if (argc > 2 && (strcmp("-n", argv[1]) == 0))
    {
       virtname = argv[2]; argv +=2; argc -=2;
    }

  if (argc > 2 && (strcmp("-m", argv[1]) == 0))
    {
       mode = argv[2]; argv +=2; argc -=2;
    }

  if (argc != 2)
    {
      help();
      exit(1);
    }

  filetype = argv[1];

  /* this is a bit ugly, but that way, we do not need to
     know the order in tex-file.h */
  if (strcmp("-gf", filetype) == 0)
    file_format = kpse_gf_format;
  else if (strcmp("-pk", filetype) == 0)
    file_format = kpse_pk_format;
  else if (strcmp("-glyph", filetype) == 0)
    file_format = kpse_any_glyph_format;
  else if (strcmp("-base", filetype) == 0)
    file_format = kpse_base_format;
  else if (strcmp("-bib", filetype) == 0)
    file_format = kpse_bib_format;
  else if (strcmp("-bst", filetype) == 0)
    file_format = kpse_bst_format;
  else if (strcmp("-cnf", filetype) == 0)
    file_format = kpse_cnf_format;
  else if (strcmp("-fmt", filetype) == 0)
    file_format = kpse_fmt_format;
  else if (strcmp("-mf", filetype) == 0)
    file_format = kpse_mf_format;
  else if (strcmp("-mfpool", filetype) == 0)
    file_format = kpse_mfpool_format;
  else if (strcmp("-pict", filetype) == 0)
    file_format = kpse_pict_format;
  else if (strcmp("-tex", filetype) == 0)
    file_format = kpse_tex_format;
  else if (strcmp("-texpool", filetype) == 0)
    file_format = kpse_texpool_format;
  else if (strcmp("-tfm", filetype) == 0)
    file_format = kpse_tfm_format;
  else if (strcmp("-vf", filetype) == 0)
    file_format = kpse_vf_format;
  else if (strcmp("-dvips_config", filetype) == 0)
    file_format = kpse_dvips_config_format;
  else if (strcmp("-dvips_header", filetype) == 0)
    file_format = kpse_dvips_header_format;
  else
    {
      fprintf(stderr, "%s: unknown filetype %s\n", progname, filetype);
      help();
    }

  kpse_set_progname (virtname);
  kpse_init_prog ("NONE", 600, mode, false, "cmr10");

  /* Disable suffix_search_only. This way, we can ask for both
     cmr10.600pk and cmr10.600. Otherwise (and this is confusing)
     we could only ask for cmr10.600.
   */
  kpse_init_format(file_format);
  kpse_format_info[file_format].suffix_search_only = false;

  if ((found = kpse_format_info[file_format].path) != NULL)
    {
      printf("%s\n", found);
      exit(0);
    }
  else
    {
      exit(1);
    }
}

/* help entries stolen from kpathsea.texi :-) */
static char *helparr[] = {
"filetype        meaning",
"-gf             generic font bitmap",
"-pk             packed bitmap font",
"-base           Metafont memory dump",
"-bib            BibTeX bibliography source",
"-bst            BibTeX style files",
"-cnf            Kpathsea runtime configuration files",
"-fmt            TeX memory dump",
"-mf             Metafont source",
"-mfpool         Metafont program strings",
"-pict           Other kinds of figures",
"-tex            TeX source",
"-texpool        TeX program strings",
"-tfm            TeX font metrics",
"-vf             virtual font",
"-dvips_config   dvips config files",
"-dvips_header   dvips header files", 0};

/* idea stolen from dvips.c */
void help()
{
   char **p ;

   fprintf (stderr, "Usage: %s [ -p program ] [-m mode ] -filetype file\n", progname);
   for (p=helparr; *p; p++)
      fprintf(stderr, " %s\n", *p) ;
   exit(1);
}
