dnl Adds R6 stuff and a bug fix to the Autoconf 1.11 version.
dnl Everything will change for Autoconf 2.0. 
undefine([AC_FIND_XTRA])dnl
define(AC_FIND_XTRA, [AC_REQUIRE([AC_ISC_POSIX])AC_REQUIRE([AC_FIND_X])
AC_CHECKING(for additional X libraries and flags)
if test -n "$x_includes"; then
  X_CFLAGS="$X_CFLAGS -I$x_includes"
elif test -n "$no_x"; then 
  # Not all programs may use this symbol, but it won't hurt to define it.
  X_CFLAGS="$X_CFLAGS -DX_DISPLAY_MISSING"
fi

# It would be nice to have a more robust check for the -R ld option than
# just checking for Solaris.
# It would also be nice to do this for all -L options, not just this one.
if test -n "$x_libraries"; then
  X_LIBS="$X_LIBS -L$x_libraries"
  if test "`(uname) 2>/dev/null`" = SunOS \
     && uname -r | grep '^5' >/dev/null; then
    X_LIBS="$X_LIBS -R$x_libraries"
  fi
fi

# Check for system-dependent libraries X programs must link with.
if test -n "$ISC"; then
  X_EXTRA_LIBS="$X_EXTRA_LIBS -lnsl_s -linet"
else
  # Martyn.Johnson@cl.cam.ac.uk says this is needed for Ultrix, if the X
  # libraries were built with DECnet support.  And karl@cs.umb.edu's Alpha
  # needs dnet_stub (dnet doesn't exist).
  AC_HAVE_LIBRARY(dnet,
    [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet"
     ac_have_dnet=t])
  if test -z "$ac_have_dnet"; then
    AC_HAVE_LIBRARY(dnet_stub, [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet_stub"])
  fi
  #
  # msh@cis.ufl.edu says -lnsl (and -lsocket) are needed for his 386/AT.
  # Not sure which flavor of 386 Unix this is, but it seems harmless to
  # check for it.
  AC_HAVE_LIBRARY(nsl, [X_EXTRA_LIBS="$X_EXTRA_LIBS -lnsl"])
  #
  # lieder@skyler.mavd.honeywell.com says without -lsocket,
  # socket/setsockopt and other routines are undefined under SCO ODT 2.0.
  # But -lsocket is broken on IRIX, according to simon@lia.di.epfl.ch.
  if test "`(uname) 2>/dev/null`" != IRIX; then
    AC_HAVE_LIBRARY(socket, [X_EXTRA_LIBS="$X_EXTRA_LIBS -lsocket"])
  fi
fi

# Check for libraries that X11R6 Xt/Xaw programs need.
save_ldflags=$LDFLAGS
LDFLAGS="$LDFLAGS -L$x_libraries"
# Unfortunately, SM needs ICE to (dynamically) link under SunOS 4.x (so
# we have to check for ICE first), but we must link in the order -lSM
# -lICE or we get undefined symbols.  Resolution is just to assume we
# have SM if we have ICE.  Why not?  Furthermore, these have to be
# linked with before -lX11, in contrast to the other libraries we check
# for below, so use a different variable.
#  --interran@uluru.Stanford.EDU, kb@cs.umb.edu.
AC_HAVE_LIBRARY(ICE $X_EXTRA_LIBS, [X_R6_LIBS="-lSM -lICE"])
LDFLAGS=$save_ldflags
#
AC_VERBOSE(X compiler flags: $X_CFLAGS)
AC_VERBOSE(X library flags: $X_LIBS)
AC_VERBOSE(R6 libraries: $X_R6_LIBS)
AC_VERBOSE(extra X libraries: $X_EXTRA_LIBS)
AC_SUBST(X_CFLAGS)dnl
AC_SUBST(X_LIBS)dnl
AC_SUBST(X_R6_LIBS)dnl
AC_SUBST(X_EXTRA_LIBS)dnl
])dnl
undefine([AC_OUTPUT])dnl
define(AC_OUTPUT,
[changequote(,)dnl

# The preferred way to propogate these variables is regular @ substitutions.
if test -n "$prefix"; then
  ac_prsub="s%^prefix\\([ 	]*\\)=\\([ 	]*\\).*$%prefix\\1=\\2$prefix%"
else
  prefix=/usr/local
fi
if test -n "$exec_prefix"; then
  ac_prsub="$ac_prsub
s%^exec_prefix\\([ 	]*\\)=\\([ 	]*\\).*$%exec_prefix\\1=\\2$exec_prefix%"
else
  exec_prefix='${prefix}' # Let make expand it.
fi

# Any assignment to VPATH causes Sun make to only execute
# the first set of double-colon rules, so remove it if not needed.
# If there is a colon in the path, we need to keep it.
if test "x$srcdir" = x.; then
  ac_vpsub='/^[ 	]*VPATH[ 	]*=[^:]*$/d'
fi

# Quote sed substitution magic chars in DEFS.
cat >conftest.def <<EOF
$DEFS
EOF
ac_escape_ampersand_and_backslash='s%[&\\]%\\&%g'
DEFS=`sed "$ac_escape_ampersand_and_backslash" <conftest.def`
rm -f conftest.def
# Substitute for predefined variables.
changequote([,])dnl
AC_SUBST(LIBS)dnl
AC_SUBST(srcdir)dnl
AC_SUBST(top_srcdir)dnl
AC_SUBST(prefix)dnl
AC_SUBST(exec_prefix)dnl
dnl Substituting for DEFS would confuse sed if it contains multiple lines.
ifdef([AC_CONFIG_NAMES],
[divert(1)dnl
s%@DEFS@%-DHAVE_CONFIG_H%],
[divert(1)dnl
s%@DEFS@%$DEFS%]
[divert(2)dnl
DEFS='$DEFS'
])dnl
divert(2)dnl
ac_prsub='$ac_prsub'
ac_vpsub='$ac_vpsub'
extrasub='$extrasub'
divert(0)dnl

trap 'rm -f config.status; exit 1' 1 2 15
echo creating config.status
rm -f config.status
cat > config.status <<EOF
#!/bin/sh
# Generated automatically by configure.
# Run this file to recreate the current configuration.
# This directory was configured as follows,
dnl hostname on some systems (SVR3.2, Linux) returns a bogus exit status,
dnl so uname gets run too.
# on host `(hostname || uname -n) 2>/dev/null | sed 1q`:
#
[#] [$]0 [$]configure_args

changequote(,)dnl
ac_cs_usage="Usage: config.status [--recheck] [--version] [--help]"
changequote([,])dnl
for ac_option
do
  case "[\$]ac_option" in
  -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
    echo running [\$]{CONFIG_SHELL-/bin/sh} [$]0 [$]configure_args --no-create
    exec [\$]{CONFIG_SHELL-/bin/sh} [$]0 [$]configure_args --no-create ;;
  -version | --version | --versio | --versi | --vers | --ver | --ve | --v)
    echo "config.status generated by autoconf version AC_ACVERSION"
    exit 0 ;;
  -help | --help | --hel | --he | --h)
    echo "[\$]ac_cs_usage"; exit 0 ;;
  *) echo "[\$]ac_cs_usage"; exit 1 ;;
  esac
done

ifdef([AC_CONFIG_NAMES],
[trap 'rm -fr $1 AC_CONFIG_NAMES conftest*; exit 1' 1 2 15],
[trap 'rm -f $1; exit 1' 1 2 15])
dnl Insert the variable assignments.
undivert(2)dnl
EOF
cat >> config.status <<\EOF

ac_given_srcdir=$srcdir

CONFIG_FILES=${CONFIG_FILES-"$1"}
for ac_file in .. ${CONFIG_FILES}; do if test "x$ac_file" != x..; then
  # Remove last slash and all that follows it.  Not all systems have dirname.
changequote(,)dnl
  ac_dir=`echo $ac_file|sed 's%/[^/][^/]*$%%'`
changequote([,])dnl
  if test "$ac_dir" != "$ac_file" && test "$ac_dir" != .; then
    # The file is in a subdirectory.
    test ! -d "$ac_dir" && mkdir "$ac_dir"
    ac_dir_suffix="/$ac_dir"
  else
    ac_dir_suffix=
  fi

changequote(,)dnl
  # A "../" for each directory in $ac_dir_suffix.
  ac_dots=`echo $ac_dir_suffix|sed 's%/[^/]*%../%g'`
changequote([,])dnl
  case "$ac_given_srcdir" in
  .)  srcdir=.
      if test -z "$ac_dir_suffix"; then top_srcdir=.
      else top_srcdir=`echo $ac_dots|sed 's%/$%%'`; fi ;;
  /*) srcdir="$ac_given_srcdir$ac_dir_suffix"; top_srcdir="$ac_given_srcdir" ;;
  *) # Relative path.
    srcdir="$ac_dots$ac_given_srcdir$ac_dir_suffix"
    top_srcdir="$ac_dots$ac_given_srcdir" ;;
  esac

  echo creating "$ac_file"
  rm -f "$ac_file"
  comment_str="Generated automatically from `echo $ac_file|sed 's|.*/||'`.in by configure."
  case "$ac_file" in
    *.c | *.h | *.C | *.cc | *.m )  echo "/* $comment_str */" > "$ac_file" ;;
    * )          echo "# $comment_str"     > "$ac_file" ;;
  esac
  # Replace lines of the form ac_include foo with the contents of foo:
  # first, from the ac_include lines construct a list of sed
  # commands to remove them, and include the files; then run sed.
  # Have to use sed because old (Ultrix, SunOS) awk does not support
  # getline or system. (Anyway, configure scripts aren't supposed to use awk.)
  # Use \@...@<cmd> form of sed address because the filename may contain /.
  # Can't use only one -e and commands {dr foo} because foo has to be last.
  # Use @e initially instead of -e because GNU echo has a -e option.
  file_substs=`sed -n \
changequote(,)dnl
"/^ac_include/s%ac_include[ 	]*\(.*\)%@e '\\\\\@^&@r \1' -e '\\\\\@^&@d'%p"\
changequote([,])dnl
               $ac_given_srcdir/${ac_file}.in`
  if test -n "$file_substs"; then
    # Change @e back to -e.
    file_subst_cmd="sed `echo $file_substs | sed s/@e/-e/g`"
  else
    # If no substitutions and hence no sed commands, don't choke.
    file_subst_cmd=cat
  fi
  # cd into the srcdir because the files being included more or less
  # must be part of the distribution. I can't find any way to do
  # variable substitution in the sed commands (so the user could have,
  # e.g., $top_srcdir in their ac_include line).
  (cd $ac_given_srcdir && eval $file_subst_cmd ${ac_file}.in) \
  | sed -e "
$ac_prsub
$ac_vpsub
dnl Shell code in configure.in might set extrasub.
$extrasub
dnl Insert the sed substitutions.
undivert(1)dnl
" >> $ac_file
fi; done
AC_OUTPUT_HEADER
$2
exit 0
EOF
chmod +x config.status
# Some shells look in PATH for config.status without the "./".
test -n "$no_create" || ${CONFIG_SHELL-/bin/sh} ./config.status
])dnl
