%% 
%% This is file `g-brief.cls', generated 
%% on <1994/10/31> with the docstrip utility (2.2h).
%% 
%% The original source files were:
%% 
%% g-brief.dtx  (with options: `class')
%% 
%% Copyright (C) 1991-1994 by Michael Lenzen. All rights reserved. 
%% 
%% 
%% This file is part of the g-brief package 
%% 
%% IMPORTANT NOTICE: 
%% 
%% You are not allowed to change this file. You may however copy this file 
%% to a file with a different name and then change the copy. 
%% 
%% You are NOT ALLOWED to distribute this file alone. You are NOT ALLOWED 
%% to take money for the distribution or use of this file (or a changed 
%% version) except for a nominal charge for copying etc. 
%% 
%% You are allowed to distribute this file under the condition that it is 
%% distributed together with all files mentioned below. 
%% 
%% If you receive only some of these files from someone, complain! 
%% 
%% Error Reports in case of UNCHANGED versions to 
%% 
%% Michael Lenzen 
%% Zur Belsmuehle 15 
%% 53347 Alfter 
%% Germany 
%% Internet: <lenzen@zaphod.rhein.de> 
%% 
\def\filedate{1994/10/01}
\def\fileversion{1.3e}
\def\filename{g-brief.cls}
\NeedsTeXFormat{LaTeX2e}[1994/06/01]

\ProvidesClass{g-brief}[\filedate\space v\fileversion\space g-brief class]

\newdimen\VorschubH
\newdimen\VorschubV
\VorschubH = 0.0mm
\VorschubV = 0.0mm

\DeclareOption{10pt}{\def\@schrift{0}}
\DeclareOption{11pt}{\def\@schrift{1}}
\DeclareOption{12pt}{\def\@schrift{2}}
\DeclareOption{german}
  {\def\sprache{german}
   \def\telefontex{{\footnotesize Telefon\/:}}
   \def\telefaxtext{{\footnotesize Telefax\/:}}
   \def\telextext{{\footnotesize Telex\/:}}
   \def\btxtext{{\footnotesize BTX\/:}}
   \def\emailtext{{\footnotesize E--Mail\/:}}
   \def\banktext{{\footnotesize Bankverbindung\/:}}
   \def\blztext{{\footnotesize BLZ}}
   \def\kontotext{{\footnotesize Kto.}}
   \def\betrefftext{{\normalsize Betr.:}}
   \def\ihrzeichentext{\footnotesize\textsc{Ihr Zeichen}}
   \def\ihrschreibentext{\footnotesize\textsc{Ihr Schreiben vom}}
   \def\meinzeichentext{\footnotesize\textsc{Mein Zeichen}}
   \def\unserzeichentext{\footnotesize\textsc{Unser Zeichen}}
   \def\datumtext{\footnotesize\textsc{Datum}}
   \def\datum{\number\day.~\ifcase\month\or Januar\or Februar\or
     M\"arz\or April\or Mai\or Juni\or Juli\or August\or September\or
     Oktober\or November\or Dezember\fi \space\number\year}}
\DeclareOption{english}
  {\def\telefontex{{\footnotesize Phone\/:}}
   \def\telefaxtext{{\footnotesize Fax\/:}}
   \def\telextext{{\footnotesize Telex\/:}}
   \def\emailtext{{\footnotesize E--Mail\/:}}
   \def\banktext{{\footnotesize Bank\/:}}
   \def\blztext{{\footnotesize code}}
   \def\kontotext{{\footnotesize acct}}
   \def\betrefftext{{\normalsize Subj.:}}
   \def\ihrzeichentext{\footnotesize\textsc{Your Ref.}}
   \def\ihrschreibentext{\footnotesize\textsc{Your Mail}}
   \def\meinzeichentext{\footnotesize\textsc{My Ref.}}
   \def\unserzeichentext{\footnotesize\textsc{Our Ref.}}
   \def\datumtext{\footnotesize\textsc{Date}}
   \def\datum{\number\day
     \ifcase\day \or
     st\or nd\or rd\or th\or th\or th\or th\or th\or th\or th\or %  1..10
     th\or th\or th\or th\or th\or th\or th\or th\or th\or th\or % 11..20
     st\or nd\or rd\or th\or th\or th\or th\or th\or th\or th\or % 21..30
     st\fi
     \space \ifcase\month \or January\or February\or March\or April\or May\or
     June\or July\or August\or September\or October\or November\or
     December\fi \space\number\year}
   \def\sprache{english}}
\DeclareOption{usenglish}
  {\def\telefontex{{\footnotesize Phone\/:}}
   \def\telefaxtext{{\footnotesize Fax\/:}}
   \def\telextext{{\footnotesize Telex\/:}}
   \def\emailtext{{\footnotesize E--Mail\/:}}
   \def\banktext{{\footnotesize Bank\/:}}
   \def\blztext{{\footnotesize code}}
   \def\kontotext{{\footnotesize acct}}
   \def\betrefftext{{\normalsize Subj.:}}
   \def\ihrzeichentext{\footnotesize\textsc{Your Ref.}}
   \def\ihrschreibentext{\footnotesize\textsc{Your Mail}}
   \def\meinzeichentext{\footnotesize\textsc{My Ref.}}
   \def\unserzeichentext{\footnotesize\textsc{Our Ref.}}
   \def\datumtext{\footnotesize\textsc{Date}}
   \def\datum{\ifcase\month\or January\or February\or March\or
     April\or May\or June\or July\or August\or September\or October\or
     November\or December\fi \space\number\day, \number\year}
   \def\sprache{usenglish}}

\ExecuteOptions{11pt,german}
\ProcessOptions

\LoadClass[1\@schrift pt, a4paper, oneside, draft]{letter}[1994/06/01]

\normalsize

\newdimen\ZA
\ZA=4.23mm

\setlength\oddsidemargin{0\p@}
\setlength\evensidemargin{\oddsidemargin}
\setlength\marginparwidth{90\p@}
\setlength\marginparsep{11\p@}
\setlength\marginparpush{5\p@}
\setlength\topmargin{-3\ZA}
\setlength\headheight{1\ZA}
\setlength\headsep{1.5\ZA}
\setlength\topskip{0.8\ZA}

\setlength\textheight{57\ZA}
\setlength\textwidth{165mm}

\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}

\renewcommand\baselinestretch{1}

\advance\topmargin by \VorschubV
\advance\oddsidemargin by \VorschubH
\setlength\evensidemargin{\oddsidemargin}

\AtEndOfClass{\pagestyle{firstpage}}

\def\Name#1{\def\name{#1}} \def\name{}
\def\Strasse#1{\def\strasse{#1}} \def\strasse{}
\def\Zusatz#1{\def\zusatz{#1}} \def\zusatz{}
\def\Ort#1{\def\ort{#1}} \def\ort{}
\def\RetourAdresse#1{\def\retouradresse{#1}} \def\retouradresse{}

\def\Telefon#1{\def\telefon{#1}} \def\telefon{}
\def\Telefax#1{\def\telefax{#1}} \def\telefax{}
\def\Telex#1{\def\telex{#1}} \def\telex{}
\def\BTX#1{\def\btx{#1}} \def\btx{}
\def\EMail#1{\def\email{#1}} \def\email{}

\def\Bank#1{\def\bank{#1}} \def\bank{}
\def\BLZ#1{\def\blz{#1}} \def\blz{}
\def\Konto#1{\def\konto{#1}} \def\konto{}

\def\Postvermerk#1{\def\postvermerk{#1}} \def\postvermerk{}
\def\Adresse#1{\def\adresse{#1}} \def\adresse{}

\def\IhrZeichen#1{\def\ihrzeichen{#1}} \def\ihrzeichen{}
\def\IhrSchreiben#1{\def\ihrschreiben{#1}} \def\ihrschreiben{}
\def\MeinZeichen#1{\def\meinzeichen{#1}} \def\meinzeichen{}
\def\Datum#1{\def\datum{#1}} \def\datum{\datum}

\def\Betreff#1{\def\betreff{#1}} \def\betreff{}

\def\Anrede#1{\def\anrede{#1}} \def\anrede{}
\def\Gruss#1#2{\def\gruss{#1} \def\grussskip{#2}}
  \def\gruss{} \def\grussskip{}

\def\Unterschrift#1{\def\unterschrift{#1}} \def\unterschrift{}

\def\Anlagen#1{\def\anlagen{#1}} \def\anlagen{}
\def\Verteiler#1{\def\verteiler{#1}} \def\verteiler{}

\long\def\Einrueckung#1{\par\begin{tabular}{@{\hspace{1in}}p{5in}@{}}
  #1\end{tabular}\par}

\newif\ifunserz\unserzfalse
  \def\unserzeichen{\unserztrue}

\newenvironment{g-brief}
 {
 \thispagestyle{firstpage}
 \setlength\unitlength{1mm}

 \c@page\@ne
 \interlinepenalty=200
 \newpage

 \begin{picture}(0,0)
   \put(-15,- 64.16){\line(1,0){3}}
   \put(-15,-170.16){\line(1,0){3}}

   \put( -7, -11.00){\makebox(85,4)
     {\scriptsize \ifx \retouradresse\empty
      \textrm{\name\ $\cdot$\ \strasse\
      $\cdot$\ \ort} \else \textrm{
      \retouradresse} \fi }}

   \put( -7, -11.10){\line(1,0){85}}

   \put(0,-17.15){\parbox[t]{3in}{\ifx \postvermerk\empty \hfill \par
       \else \textbf{\postvermerk} \par \vspace{2mm} \fi \adresse}}

   \put(-7,-7.15){\line( 1, 0){1}}
   \put(-7,-7.15){\line( 0,-1){1}}
   \put(78,-7.15){\line(-1, 0){1}}
   \put(78,-7.15){\line( 0,-1){1}}
   \put(-7,-50.0){\line( 1, 0){1}}
   \put(-7,-50.0){\line( 0, 1){1}}
   \put(78,-50.0){\line(-1, 0){1}}
   \put(78,-50.0){\line( 0, 1){1}}
 \end{picture}

 \vspace{11.5\ZA}

 \ifx \ihrzeichen\empty \ifx \ihrschreiben\empty \ifx
 \meinzeichen\empty \makebox[45.5mm][l]{} \makebox[55.0mm][l]{}
 \makebox[20.0mm][l]{} \else \makebox[45.5mm][l]{\ihrzeichentext}
 \makebox[55.0mm][l]{\ihrschreibentext} \ifunserz
 \makebox[20.0mm][l]{\unserzeichentext} \else
 \makebox[20.0mm][l]{\meinzeichentext} \fi \fi \else
 \makebox[45.5mm][l]{\ihrzeichentext}
 \makebox[55.0mm][l]{\ihrschreibentext} \ifunserz
 \makebox[20.0mm][l]{\unserzeichentext} \else
 \makebox[20.0mm][l]{\meinzeichentext} \fi \fi \else
 \makebox[45.5mm][l]{\ihrzeichentext}
 \makebox[55.0mm][l]{\ihrschreibentext} \ifunserz
 \makebox[20.0mm][l]{\unserzeichentext} \else
 \makebox[20.0mm][l]{\meinzeichentext} \fi \fi
 \makebox[37.0mm][r]{\datumtext} \\
 \makebox[45.5mm][l]{\ihrzeichen}
 \makebox[55.0mm][l]{\ihrschreiben}
 \makebox[20.0mm][l]{\meinzeichen}
 \makebox[37.0mm][r]{\datum} \par

 \vspace{8mm}

 \ifcase\@ptsize\vspace{0.045pt}\or \vspace{-1.555pt}\or
 \vspace{-2.955pt} \fi

 \ifx \betreff\empty \else \betrefftext \space \space \betreff \mbox{}
 \par \vspace{-1\parskip} \vspace{8mm} \fi

 \ifcase\@ptsize\vspace{0.045pt}\or \vspace{-1.555pt}\or
 \vspace{-2.955pt} \fi

 \ifx \anrede\empty \else \anrede \par \fi\nobreak
 }
 {
 \vspace{\grussskip} \par \nobreak \stopbreaks \noindent
 \parbox[t]{3.5in}{\raggedright \ignorespaces {\normalsize \ifx
     \gruss\empty \else \gruss \mbox{} \\[4\ZA] \fi \ifx
     \empty\unterschrift \relax \else \textsl{(\unterschrift)}}
   \fi\strut} \ifx \anlagen\empty \else \vspace{4mm} \par \anlagen
 \par \fi \ifx \verteiler\empty \else \ifx \anlagen\empty
 \vspace{4mm}\par \fi \verteiler \fi }

\def\ps@firstpage{ \headheight16pt \def\@oddhead{\unitlength1mm
   \begin{picture}(0,0)
     \put(-9, 3){\parbox{180mm}{\LARGE\textit{\quad\name}}}
     \put(-9, 4){\parbox{180mm}{\hfill \normalsize \textsl{
        \begin{tabular}{r} \strasse \quad \\ \ifx \zusatz\empty \else
        \zusatz \quad \\ \fi \ort \quad \end{tabular}}}}
     \put(-9,-7){\rule{180mm}{0.5pt}}
   \end{picture} \hfill}
 \def\@oddfoot{\unitlength1mm
   \def\istsprache{german}
   \begin{picture}(0,0)
     \put(-9,0){\parbox{180mm}{\footnotesize\rule{180mm}{0.5pt}
     \begin{tabular}{ll}
       \ifx \telefon\empty \else \telefontex & \telefon \\ \fi \ifx
       \telefax\empty \else \telefaxtext & \telefax \\ \fi \ifx
       \telex\empty \else \telextext & \telex \\ \fi \ifx
       \sprache\istsprache \ifx \btx\empty \else \btxtext & \btx \\
       \fi \fi \ifx \email\empty \else \emailtext & \email \\ \fi \
     \end{tabular}\hfill
     \begin{tabular}{ll}
       \ifx \bank\empty \else \ifx \blz\empty \else \ifx
       \konto\empty \else \banktext & \bank \\ & \blztext \space \blz
       \\ & \kontotext \space \konto \\ \ \fi \fi \fi
     \end{tabular}}}
  \end{picture} \hfill}
\def\@evenhead{\@oddhead} \def\@evenfoot{\@oddfoot}}

\def\ps@regularpage{\headheight36pt\def\@oddhead{\unitlength1mm
   \begin{picture}(0,0)
     \put(-9,0){\makebox(180,15){\normalsize\textit{\quad\name}
         \hfill\textsl{\datum\hfill\pagename\ \thepage\quad}}}
     \put(-9,0){\rule{180mm}{0.5pt}}
   \end{picture}\hfill}
 \def\@oddfoot{\empty} \def\@evenhead{\@oddhead}
 \def\@evenfoot{\@oddfoot}}

\def\istsprache{german}
\ifx \sprache\istsprache
  \IfFileExists{babel.sty}
    {\RequirePackage[german]{babel}[1994/06/05] }
    {\IfFileExists{german.sty}
      {\RequirePackage{german}}
        {\ClassError{g-brief}
          {Neither babel nor german.sty installed !!!}
          {Get babel or german.sty !!!}}}
\fi


\endinput
%% 
%% End of file `g-brief.cls'.
