#ifndef lint
static char rcsid[] = "$Header: /ful/chris/ctex_dist/lib/RCS/error.c,v 1.1 84/05/20 23:11:37 chris Exp $";
#endif

/* Error message routine */

#include <stdio.h>

#ifdef lint
/* VARARGS */
/* ARGSUSED */
error (quit, e, fmt)
int quit, e;
char *fmt;
{
}

#else lint

extern char *ProgName;
extern char *sys_errlist[];
extern int   sys_nerr;

#ifdef pyr	/* pyramid hacks */
#include <varargs.h>
#endif pyr

/* Print an error message with an optional system error number and optionally
   quit */
error (quit, e, fmt, arg, arg2, arg3, arg4)
int quit, e;
char *fmt;
{
#if 1 /* brute force,cks */
    fprintf (stderr, "%s: ", ProgName);
    fprintf (stderr, fmt, arg, arg2, arg3, arg4);
#else
#ifdef pyr
    va_buf _va;
    va_list l;

    fprintf (stderr, "%s: ", ProgName);
    _vastart (l = (va_list)_va, &arg);
    _doprnt (fmt, l, stderr);
#else pyr
    fprintf (stderr, "%s: ", ProgName);
    _doprnt (fmt, &arg, stderr);
#endif pyr
#endif
    if (e) {
	register char *s = e < sys_nerr ? sys_errlist[e] : "Unknown error";
	fprintf (stderr, ": %s", s);
    }
    putc ('\n', stderr);
    fflush (stderr);		/* just in case */
    if (quit)
	exit (quit);
}

#endif lint
