
/* My first sound mixer program. :)
   Thanks to xmix for example code on setting volumes.

   This one just modifies the master sound volume.


*/

#include	<sys/types.h>
#include	<stdio.h>
#include	<fcntl.h>
#include <linux/soundcard.h>

static char *version = "volume 1.1  -Sam Lantinga  5/31/94";

#define DEV_MIXER		"/dev/mixer"
#define MAX_VOLUME	95
#define MIN_VOLUME	05
#define RIGHT			0x01
#define LEFT			0x02

typedef struct stereovolume
{
	unsigned char left;
	unsigned char right;
} StereoVolume;

unsigned char getvolume(char *value)
{
	unsigned char setting;
	int percentage=0;

	if ( *(value+strlen(value)-1) == '%' ) {
		*(value+strlen(value)-1)='\0';
		++percentage;
	}
	if ( (setting=(unsigned char)atoi(value)) == 0 )
		return(0);

	if ( percentage )
		setting=((((MAX_VOLUME-MIN_VOLUME)*setting)/100)+MIN_VOLUME);
	else if ( setting > MAX_VOLUME )
		setting=MAX_VOLUME;
	else if ( setting < MIN_VOLUME )
		setting=MIN_VOLUME;
	return(setting);
}

void setvolume(int which, unsigned char setting, StereoVolume *volptr)
{
	if ( setting < MIN_VOLUME )
		setting=MIN_VOLUME;
	if ( setting > MAX_VOLUME )
		setting=MAX_VOLUME;

	if ( which&RIGHT )
		volptr->right=setting;
	if ( which&LEFT )
		volptr->left=setting;
}

void print_usage(char *cmd)
{
	fprintf(stderr, "Usage: %s [-r volume] [-l volume] master_volume\n", cmd);
	exit(1);
}

main(int argc, char *argv[])
{
	extern int optind;		/* For getopt() */
	extern char *optarg;		/* For getopt() */

	int mixer_fd, c;
	unsigned char setting;
	StereoVolume volume;
	char *progname=argv[0];

	/* Open the mixer device first */
	if ( (mixer_fd=open(DEV_MIXER, O_RDWR, 0)) < 0 ) {
		fprintf(stderr, "Can't open %s: ", DEV_MIXER);
		perror("");
		exit(2);
	}

	if ( ioctl(mixer_fd, MIXER_READ(SOUND_MIXER_VOLUME), &volume) < 0 ) {
		perror("Can't obtain current volume settings");
		exit(2);
	}

	if ( ! argv[1] ) {
		printf("Current volume: R = %d, L = %d\n", volume.right, volume.left);
		exit(0);
	}

	/* Get command line options and set volume */
	while ( (c=getopt(argc, argv, "hr:l:")) != EOF ) {
		switch (c) {
			case 'r':	if ( (setting=getvolume(optarg)) == 0 ) {
								fprintf(stderr, "Bad volume setting: %s\n", optarg);
								exit(1);
							}
							setvolume(RIGHT, setting, &volume);
							break;
			case 'l':	if ( (setting=getvolume(optarg)) == 0 ) {
								fprintf(stderr, "Bad volume setting: %s\n", optarg);
								exit(1);
							}
							setvolume(LEFT, setting, &volume);
							break;
			default:		print_usage(progname);
		}
	}
	argv += optind;

	if ( argv[0] && argv[1] )
		print_usage(progname);
	else if ( argv[0] ) {
		if ( (setting=getvolume(argv[0])) == 0 ) {
			fprintf(stderr, "Bad volume setting: %s\n", argv[0]);
			exit(1);
		}
		setvolume(LEFT|RIGHT, setting, &volume);
	}
	if ( ioctl(mixer_fd, MIXER_WRITE(SOUND_MIXER_VOLUME), &volume) < 0 ) {
		perror("Can't set current volume settings");
		exit(2);
	}
	exit(0);
}
